/*
 * Decompiled with CFR 0.152.
 */
package utils.serialize.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.util.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import utils.serialize.json.ArrayMergeStrategy;
import utils.serialize.json.JSONBeanDeserializer;
import utils.serialize.json.JSONBeanSerializer;

@JSONType(serializer=JSONBeanSerializer.class, deserializer=JSONBeanDeserializer.class)
public class JSONBean {
    private static final String KEY_PATH_REGEX = "\\A([\\w\\$]+(\\[\\d+\\])?\\.)*[\\w\\$]+\\z";
    private static final Pattern KEY_PATH_PATTERN = Pattern.compile("\\A([\\w\\$]+(\\[\\d+\\])?\\.)*[\\w\\$]+\\z");
    private JSONObject jsonObject;

    public JSONBean() {
        this(new JSONObject());
    }

    protected JSONBean(JSONObject jsonObj) {
        this.jsonObject = jsonObj;
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public boolean isEmpty() {
        return this.jsonObject.isEmpty();
    }

    public JSONBean merge(JSONBean jsonBean) {
        if (jsonBean == this) {
            return this;
        }
        return this.merge(jsonBean, ArrayMergeStrategy.REPLACE);
    }

    protected Object get(String keyPath) {
        if (!KEY_PATH_PATTERN.matcher(keyPath).matches()) {
            throw new IllegalArgumentException("Illegal key path! --keyPath=[" + keyPath + "]");
        }
        int startInx = 0;
        int endIdx = -1;
        Object value = null;
        do {
            String key;
            if ((endIdx = keyPath.indexOf(46, startInx)) > startInx) {
                key = keyPath.substring(startInx, endIdx);
                startInx = endIdx + 1;
            } else {
                key = keyPath.substring(startInx);
            }
            String field = key;
            int leftIdx = key.indexOf(91);
            int position = -1;
            if (leftIdx > 0) {
                field = key.substring(0, leftIdx);
                position = Integer.parseInt(key.substring(leftIdx + 1, key.length() - 1));
            }
            if (value == null) {
                value = this.jsonObject.get((Object)field);
            } else if (value instanceof JSONObject) {
                value = ((JSONObject)value).get((Object)field);
            } else {
                if (value instanceof JSONArray) {
                    throw new IllegalArgumentException("Array cann't be accessed by field[" + field + "]!");
                }
                throw new IllegalArgumentException("JSON primitive value cann't be accessed by field[" + field + "]!");
            }
            if (value == null) {
                return null;
            }
            if (position <= -1) continue;
            if (value instanceof JSONArray) {
                JSONArray arrayValue = (JSONArray)value;
                if (position < arrayValue.size()) {
                    value = arrayValue.get(position);
                    continue;
                }
                throw new IndexOutOfBoundsException("Index[" + position + "] out of the size of array field[" + field + "]!");
            }
            if (value instanceof JSONObject) {
                throw new IllegalArgumentException("JSON object field[" + field + "] cann't be accessed by array index!");
            }
            throw new IllegalArgumentException("JSON primitive value field[" + field + "] cann't be accessed by array index!");
        } while (endIdx > -1);
        return value;
    }

    protected void set(String key, Object value) {
        this.jsonObject.put(key, value);
    }

    public <T> T getObject(String key, Class<T> clazz) {
        Object obj = this.get(key);
        return (T)TypeUtils.castToJavaBean((Object)obj, clazz);
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return TypeUtils.castToBoolean((Object)value);
    }

    public byte[] getBytes(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return TypeUtils.castToBytes((Object)value);
    }

    public boolean getBooleanValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return false;
        }
        return TypeUtils.castToBoolean((Object)value);
    }

    public Byte getByte(String key) {
        Object value = this.get(key);
        return TypeUtils.castToByte((Object)value);
    }

    public byte getByteValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToByte((Object)value);
    }

    public Short getShort(String key) {
        Object value = this.get(key);
        return TypeUtils.castToShort((Object)value);
    }

    public short getShortValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToShort((Object)value);
    }

    public Integer getInteger(String key) {
        Object value = this.get(key);
        return TypeUtils.castToInt((Object)value);
    }

    public int getIntValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToInt((Object)value);
    }

    public Long getLong(String key) {
        Object value = this.get(key);
        return TypeUtils.castToLong((Object)value);
    }

    public long getLongValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0L;
        }
        return TypeUtils.castToLong((Object)value);
    }

    public Float getFloat(String key) {
        Object value = this.get(key);
        return TypeUtils.castToFloat((Object)value);
    }

    public float getFloatValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0.0f;
        }
        return TypeUtils.castToFloat((Object)value).floatValue();
    }

    public Double getDouble(String key) {
        Object value = this.get(key);
        return TypeUtils.castToDouble((Object)value);
    }

    public double getDoubleValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0.0;
        }
        return TypeUtils.castToDouble((Object)value);
    }

    public BigDecimal getBigDecimal(String key) {
        Object value = this.get(key);
        return TypeUtils.castToBigDecimal((Object)value);
    }

    public BigInteger getBigInteger(String key) {
        Object value = this.get(key);
        return TypeUtils.castToBigInteger((Object)value);
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public java.util.Date getDate(String key) {
        Object value = this.get(key);
        return TypeUtils.castToDate((Object)value);
    }

    public Date getSqlDate(String key) {
        Object value = this.get(key);
        return TypeUtils.castToSqlDate((Object)value);
    }

    public Timestamp getTimestamp(String key) {
        Object value = this.get(key);
        return TypeUtils.castToTimestamp((Object)value);
    }

    public String toString() {
        return this.jsonObject.toJSONString();
    }

    public <T> T toJavaBean(Class<T> beanClass) {
        return (T)this.jsonObject.toJavaObject(beanClass);
    }

    public JSONBean merge(JSONBean jsonBean, ArrayMergeStrategy arrayMergeStrategy) {
        JSONBean.mergeJSONObject(this.jsonObject, jsonBean.jsonObject, arrayMergeStrategy);
        return this;
    }

    private static void mergeJSONObject(JSONObject target, JSONObject from, ArrayMergeStrategy arrayMergeStrategy) {
        for (Map.Entry field : from.entrySet()) {
            if (target.containsKey(field.getKey())) {
                Object targetFieldValue = target.get(field.getKey());
                Object fromFieldValue = field.getValue();
                if (targetFieldValue instanceof JSONObject && fromFieldValue instanceof JSONObject) {
                    JSONBean.mergeJSONObject((JSONObject)targetFieldValue, (JSONObject)fromFieldValue, arrayMergeStrategy);
                    continue;
                }
                if (targetFieldValue instanceof JSONArray && fromFieldValue instanceof JSONArray) {
                    JSONBean.mergeJSONArray((JSONArray)targetFieldValue, (JSONArray)fromFieldValue, arrayMergeStrategy);
                    continue;
                }
                target.put((String)field.getKey(), field.getValue());
                continue;
            }
            target.put((String)field.getKey(), field.getValue());
        }
    }

    private static void mergeJSONArray(JSONArray target, JSONArray from, ArrayMergeStrategy strategy) {
        switch (strategy) {
            case REPLACE: {
                if (target.size() > from.size()) {
                    for (int i = 0; i < from.size(); ++i) {
                        target.set(i, from.get(i));
                    }
                    break;
                }
                target.clear();
                target.addAll((Collection)from);
                break;
            }
            case APPEND: {
                target.addAll((Collection)from);
                break;
            }
            case DEEP_MERGE: {
                int i;
                int mergeCount = Math.min(target.size(), from.size());
                for (i = 0; i < mergeCount; ++i) {
                    Object targetFieldValue = target.get(i);
                    Object fromFieldValue = from.get(i);
                    if (targetFieldValue instanceof JSONObject && fromFieldValue instanceof JSONObject) {
                        JSONBean.mergeJSONObject((JSONObject)targetFieldValue, (JSONObject)fromFieldValue, strategy);
                        continue;
                    }
                    if (targetFieldValue instanceof JSONArray && fromFieldValue instanceof JSONArray) {
                        JSONBean.mergeJSONArray((JSONArray)targetFieldValue, (JSONArray)fromFieldValue, strategy);
                        continue;
                    }
                    target.set(i, fromFieldValue);
                }
                if (from.size() <= target.size()) break;
                for (i = target.size(); i < from.size(); ++i) {
                    target.add(from.get(i));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported strategy[" + (Object)((Object)strategy) + "] for merging json array!");
            }
        }
    }

    public static JSONBean parse(String json) {
        JSONObject jsonObj = JSONBean.parseJSONObject(json);
        return new JSONBean(jsonObj);
    }

    public static JSONBean wrap(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null object!");
        }
        if (object instanceof JSONBean) {
            return (JSONBean)object;
        }
        JSONObject jsonObj = JSONBean.toJSONObject(object);
        return new JSONBean(jsonObj);
    }

    public static JSONBean tryWrap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONBean) {
            return (JSONBean)object;
        }
        JSONObject jsonObj = JSONBean.tryToJSONObject(object);
        if (jsonObj == null) {
            return null;
        }
        return new JSONBean(jsonObj);
    }

    public static JSONObject tryToJSONObject(Object javaObject) {
        if (javaObject == null) {
            return null;
        }
        if (javaObject instanceof JSONObject) {
            return (JSONObject)javaObject;
        }
        if (javaObject instanceof Collection) {
            return null;
        }
        Class<?> cls = javaObject.getClass();
        if (cls.isArray()) {
            return null;
        }
        if (cls.isEnum()) {
            return null;
        }
        if (JSONBean.isPrimitive(cls)) {
            return null;
        }
        Object obj = JSONObject.toJSON((Object)javaObject);
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        return null;
    }

    private static JSONObject parseJSONObject(String json) {
        Object obj = JSON.parse((String)json);
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        throw new IllegalArgumentException("The specified json string is not a JSON Object!");
    }

    private static JSONObject toJSONObject(Object javaObject) {
        if (javaObject == null) {
            throw new IllegalArgumentException("The wrapped java object is null!");
        }
        if (javaObject instanceof JSONObject) {
            return (JSONObject)javaObject;
        }
        if (javaObject instanceof Collection) {
            throw new IllegalArgumentException("The wrapped java object is a collection!");
        }
        Class<?> cls = javaObject.getClass();
        if (cls.isArray()) {
            throw new IllegalArgumentException("The wrapped java object is a array!");
        }
        if (cls.isEnum()) {
            throw new IllegalArgumentException("The wrapped java object is a enum!");
        }
        if (JSONBean.isPrimitive(cls)) {
            throw new IllegalArgumentException("The wrapped java object is a primitive value!");
        }
        Object obj = JSONObject.toJSON((Object)javaObject);
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        throw new IllegalArgumentException("The wrapped java object cann't be converted to a JSON Object!");
    }

    private static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Time.class || clazz == Timestamp.class || clazz.isEnum();
    }
}

