/*
 * Decompiled with CFR 0.152.
 */
package utils.serialize.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeBeanInfo;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.spi.Module;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import utils.provider.Provider;
import utils.provider.ProviderManager;
import utils.serialize.json.DynamicTypeConfigureModule;
import utils.serialize.json.DynamicTypeConverter;
import utils.serialize.json.JSONAutoConfigure;
import utils.serialize.json.JSONConfigurator;
import utils.serialize.json.ProxyTypeConfigureModule;
import utils.serialize.json.RuntimeDeserializer;
import utils.serialize.json.SuperTypeSerializationModule;
import utils.serialize.json.ToStringSerializer;

class JSONGlobalConfigurator
implements JSONConfigurator {
    public static final JSONConfigurator INSTANCE = new JSONGlobalConfigurator();
    private static final ProviderManager pm = new ProviderManager();
    static final SerializeConfig SERIALIZE_CONFIG = SerializeConfig.getGlobalInstance();
    static final ParserConfig PARSER_CONFIG = ParserConfig.getGlobalInstance();
    private static final ToStringSerializer TO_STRING_SERIALIZER = new ToStringSerializer();
    private static final RuntimeDeserializer RUNTIME_DESERIALIZER = new RuntimeDeserializer();
    private static final SuperTypeSerializationModule SUPER_TYPE_SERIALIZATION_MODULE = SuperTypeSerializationModule.INSTANCE;
    private static final ProxyTypeConfigureModule PROXY_TYPE_SERIALIZATION_MODULE = ProxyTypeConfigureModule.INSTANCE;
    private static final DynamicTypeConfigureModule DYNAMIC_TYPE_SERIALIZATION_MODULE = DynamicTypeConfigureModule.INSTANCE;
    private static final Module[] GLOBAL_SERIALIZE_MODULES = new Module[]{SUPER_TYPE_SERIALIZATION_MODULE, PROXY_TYPE_SERIALIZATION_MODULE, DYNAMIC_TYPE_SERIALIZATION_MODULE};
    private static final Module[] GLOBAL_DESERIALIZE_MODULES = new Module[]{PROXY_TYPE_SERIALIZATION_MODULE};
    private static volatile boolean inited = false;

    JSONGlobalConfigurator() {
    }

    static synchronized void initConfiguration() {
        if (inited) {
            return;
        }
        PARSER_CONFIG.setAutoTypeSupport(true);
        for (Module module : GLOBAL_SERIALIZE_MODULES) {
            SERIALIZE_CONFIG.register(module);
        }
        for (Module module : GLOBAL_DESERIALIZE_MODULES) {
            PARSER_CONFIG.register(module);
        }
        inited = true;
    }

    private static void autoRegister(JSONConfigurator configuration) {
        pm.installAllProviders(JSONAutoConfigure.class, JSONAutoConfigure.class.getClassLoader());
        pm.installAllProviders(JSONAutoConfigure.class, Thread.currentThread().getContextClassLoader());
        Collection providers = pm.getAllProviders(JSONAutoConfigure.class);
        for (Provider provider : providers) {
            JSONGlobalConfigurator.register((Provider<JSONAutoConfigure>)provider, configuration);
        }
    }

    private static void register(Provider<JSONAutoConfigure> provider, JSONConfigurator configuration) {
        ((JSONAutoConfigure)provider.getService()).configure(configuration);
    }

    @Override
    public void configSuperSerializer(Class<?> superType, ObjectSerializer serializer) {
        SUPER_TYPE_SERIALIZATION_MODULE.registerSuperSerializer(superType, serializer);
    }

    @Override
    public void configProxyInterfaces(Class<?> ... types) {
        PROXY_TYPE_SERIALIZATION_MODULE.register(types);
    }

    @Override
    public void registerDynamicTypeConverter(DynamicTypeConverter typeConverter) {
        DYNAMIC_TYPE_SERIALIZATION_MODULE.register(typeConverter);
    }

    @Override
    public void configDeserializeTypeMapping(Class<?> fromClazz, Class<?> toClazz) {
        RUNTIME_DESERIALIZER.addTypeMap(fromClazz, toClazz);
        PARSER_CONFIG.putDeserializer(fromClazz, (ObjectDeserializer)RUNTIME_DESERIALIZER);
    }

    @Override
    public void configSerialization(Class<?> clazz, ObjectSerializer serializer, ObjectDeserializer deserializer) {
        SERIALIZE_CONFIG.put(clazz, serializer);
        PARSER_CONFIG.putDeserializer(clazz, deserializer);
    }

    @Override
    public void configSerializer(Class<?> clazz, ObjectSerializer serializer) {
        SERIALIZE_CONFIG.put(clazz, serializer);
    }

    @Override
    public void configDeserializer(Class<?> clazz, ObjectDeserializer deserializer) {
        PARSER_CONFIG.putDeserializer(clazz, deserializer);
    }

    @Deprecated
    public void configOutputTypeName(Class<?> clazz, boolean enable) {
        SERIALIZE_CONFIG.config(clazz, SerializerFeature.WriteClassName, enable);
    }

    @Override
    public void configStringSerializer(Class<?> type) {
        SERIALIZE_CONFIG.put(type, (ObjectSerializer)TO_STRING_SERIALIZER);
    }

    @Override
    public void disableCircularReferenceDetect() {
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
    }

    protected static SerializeBeanInfo buildBeanInfo(Class<?> beanType, boolean outputClassName) {
        List sortedFieldList;
        int features;
        Map aliasMap = null;
        PropertyNamingStrategy propertyNamingStrategy = null;
        boolean fieldBased = false;
        JSONType jsonType = (JSONType)TypeUtils.getAnnotation(beanType, JSONType.class);
        String[] orders = null;
        String typeName = null;
        String typeKey = null;
        if (jsonType != null) {
            Class<?> interfaceClass;
            JSONType superJsonType;
            JSONType superJsonType22;
            Object supperClass;
            PropertyNamingStrategy jsonTypeNaming;
            orders = jsonType.orders();
            typeName = jsonType.typeName();
            if (typeName.length() == 0) {
                typeName = null;
            }
            if ((jsonTypeNaming = jsonType.naming()) != PropertyNamingStrategy.CamelCase) {
                propertyNamingStrategy = jsonTypeNaming;
            }
            features = SerializerFeature.of((SerializerFeature[])jsonType.serialzeFeatures());
            for (supperClass = beanType.getSuperclass(); supperClass != null && supperClass != Object.class && (superJsonType22 = (JSONType)TypeUtils.getAnnotation(supperClass, JSONType.class)) != null && (typeKey = superJsonType22.typeKey()).length() == 0; supperClass = supperClass.getSuperclass()) {
            }
            supperClass = beanType.getInterfaces();
            int superJsonType22 = ((Class<?>[])supperClass).length;
            for (int i = 0; i < superJsonType22 && ((superJsonType = (JSONType)TypeUtils.getAnnotation(interfaceClass = supperClass[i], JSONType.class)) == null || (typeKey = superJsonType.typeKey()).length() == 0); ++i) {
            }
            if (typeKey != null && typeKey.length() == 0) {
                typeKey = null;
            }
        } else {
            features = 0;
        }
        features = SerializerFeature.config((int)features, (SerializerFeature)SerializerFeature.WriteClassName, (boolean)outputClassName);
        HashMap fieldCacheMap = new HashMap();
        ParserConfig.parserAllFieldToCache(beanType, fieldCacheMap);
        List fieldInfoList = fieldBased ? TypeUtils.computeGettersWithFieldBase(beanType, aliasMap, (boolean)false, (PropertyNamingStrategy)propertyNamingStrategy) : TypeUtils.computeGetters(beanType, (JSONType)jsonType, aliasMap, fieldCacheMap, (boolean)false, (PropertyNamingStrategy)propertyNamingStrategy);
        Object[] fields = new FieldInfo[fieldInfoList.size()];
        fieldInfoList.toArray(fields);
        if (orders != null && orders.length != 0) {
            sortedFieldList = fieldBased ? TypeUtils.computeGettersWithFieldBase(beanType, aliasMap, (boolean)true, (PropertyNamingStrategy)propertyNamingStrategy) : TypeUtils.computeGetters(beanType, (JSONType)jsonType, aliasMap, fieldCacheMap, (boolean)true, (PropertyNamingStrategy)propertyNamingStrategy);
        } else {
            sortedFieldList = new ArrayList(fieldInfoList);
            Collections.sort(sortedFieldList);
        }
        Object[] sortedFields = new FieldInfo[sortedFieldList.size()];
        sortedFieldList.toArray(sortedFields);
        if (Arrays.equals(sortedFields, fields)) {
            sortedFields = fields;
        }
        return new SerializeBeanInfo(beanType, jsonType, typeName, typeKey, features, (FieldInfo[])fields, (FieldInfo[])sortedFields);
    }

    static {
        JSONGlobalConfigurator.initConfiguration();
        JSONGlobalConfigurator.autoRegister(INSTANCE);
    }
}

