/*
 * Decompiled with CFR 0.152.
 */
package utils.serialize.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import utils.PrimitiveUtils;
import utils.serialize.json.DynamicTypeConverter;
import utils.serialize.json.GenericType;
import utils.serialize.json.JSONBean;
import utils.serialize.json.JSONGlobalConfigurator;
import utils.serialize.json.JSONString;

public abstract class JSONSerializeUtils {
    public static synchronized void enableAutoConfigure() {
        JSONGlobalConfigurator.initConfiguration();
    }

    public static SerializeConfig getSerializeConfig() {
        return JSONGlobalConfigurator.SERIALIZE_CONFIG;
    }

    public static ParserConfig getParserConfig() {
        return JSONGlobalConfigurator.PARSER_CONFIG;
    }

    public static void configProxyInterfaces(Class<?> ... types) {
        JSONGlobalConfigurator.INSTANCE.configProxyInterfaces(types);
    }

    public static void registerDynamicTypeConverter(DynamicTypeConverter typeConverter) {
        JSONGlobalConfigurator.INSTANCE.registerDynamicTypeConverter(typeConverter);
    }

    public static void configDeserializeTypeMapping(Class<?> fromClazz, Class<?> toClazz) {
        JSONGlobalConfigurator.INSTANCE.configDeserializeTypeMapping(fromClazz, toClazz);
    }

    public static void configSerialization(Class<?> clazz, ObjectSerializer serializer, ObjectDeserializer deserializer) {
        JSONGlobalConfigurator.INSTANCE.configSerialization(clazz, serializer, deserializer);
    }

    public static void configSerialization(Class<?> clazz, ObjectSerializer serializer) {
        JSONGlobalConfigurator.INSTANCE.configSerializer(clazz, serializer);
    }

    public static void configDeserializer(Class<?> clazz, ObjectDeserializer deserializer) {
        JSONGlobalConfigurator.INSTANCE.configDeserializer(clazz, deserializer);
    }

    public static void configStringSerializer(Class<?> type) {
        JSONGlobalConfigurator.INSTANCE.configStringSerializer(type);
    }

    public static void disableCircularReferenceDetect() {
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
    }

    private JSONSerializeUtils() {
    }

    public static Type getGenericType(Object obj) {
        return JSONSerializeUtils.getGenericTypes(obj)[0];
    }

    public static Type[] getGenericTypes(Object obj) {
        Type superClass = obj.getClass().getGenericSuperclass();
        Type[] types = ((ParameterizedType)superClass).getActualTypeArguments();
        return types;
    }

    public static boolean isJSON(String str) {
        return JSONSerializeUtils.isJSONObject(str) || JSONSerializeUtils.isJSONOArray(str) || JSONSerializeUtils.isJSONOValue(str);
    }

    public static boolean isJSONObject(String str) {
        return str.startsWith("{") && str.endsWith("}");
    }

    public static boolean isJSONOArray(String str) {
        return str.startsWith("[") && str.endsWith("]");
    }

    public static boolean isJSONOValue(String str) {
        return str.startsWith("\"") && str.endsWith("\"");
    }

    public static String serializeToJSON(Object data) {
        return JSONSerializeUtils.serializeToJSON(data, null, false);
    }

    public static String serializeToJSON(Object data, Class<?> serializedType) {
        return JSONSerializeUtils.serializeToJSON(data, serializedType, false);
    }

    public static String serializeToJSON(Object data, boolean prettyFormat) {
        return JSONSerializeUtils.serializeToJSON(data, null, prettyFormat);
    }

    public static String serializeToJSON(Object data, Class<?> serializedType, boolean prettyFormat) {
        return JSONSerializeUtils.serializeToJSON(data, serializedType, null, prettyFormat);
    }

    public static String serializeToJSON(Object data, Class<?> serializedType, String dateFormat, boolean prettyFormat) {
        try (SerializeWriter out = prettyFormat ? new SerializeWriter((Writer)null, JSON.DEFAULT_GENERATE_FEATURE, new SerializerFeature[]{SerializerFeature.PrettyFormat}) : new SerializeWriter((Writer)null, JSON.DEFAULT_GENERATE_FEATURE, SerializerFeature.EMPTY);){
            if (data == null) {
                String string = null;
                return string;
            }
            if (serializedType == null) {
                serializedType = data.getClass();
            } else if (!(PrimitiveUtils.isPrimitiveType(serializedType) || PrimitiveUtils.isPrimitiveType(data.getClass()) || serializedType.isAssignableFrom(data.getClass()))) {
                throw new IllegalArgumentException("The serialized type[" + serializedType.getName() + "] isn't assignable from the data type[" + data.getClass().getName() + "]!");
            }
            if (PrimitiveUtils.isWrapping(data.getClass(), serializedType)) {
                serializedType = data.getClass();
            }
            Object serializer = new JSONSerializer(out, JSONGlobalConfigurator.SERIALIZE_CONFIG);
            if (dateFormat != null && dateFormat.length() != 0) {
                serializer.setDateFormat(dateFormat);
                serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
            }
            ObjectSerializer writer = serializer.getObjectWriter(serializedType);
            writer.write(serializer, data, null, null, JSON.DEFAULT_GENERATE_FEATURE);
            serializer = out.toString();
            return serializer;
        }
    }

    public static <T> T deserializeFromJSON(String json, Class<T> dataClazz) {
        return (T)JSON.parseObject((String)json, dataClazz, (ParserConfig)JSONGlobalConfigurator.PARSER_CONFIG, (Feature[])new Feature[0]);
    }

    public static <T> T deserializeFromJSONObject(JSONObject jsonObj, Class<T> dataInterface) {
        return (T)Proxy.newProxyInstance(dataInterface.getClassLoader(), new Class[]{dataInterface}, (InvocationHandler)jsonObj);
    }

    public static <T> T deserializeFromJSON(String json, GenericType<T> type) {
        return (T)JSON.parseObject((String)json, (Type)type.getTypeArgument(), (ParserConfig)JSONGlobalConfigurator.PARSER_CONFIG, (Feature[])new Feature[0]);
    }

    public static <T> T deserializeAs(Object data, Class<T> clazz) {
        if (data == null) {
            return null;
        }
        if (data instanceof JSON) {
            return (T)((JSON)data).toJavaObject(clazz);
        }
        if (data instanceof JSONBean) {
            return ((JSONBean)data).toJavaBean(clazz);
        }
        if (data instanceof String) {
            if (clazz.isInterface()) {
                JSONObject jsonObj = JSONSerializeUtils.deserializeAs(data, JSONObject.class);
                return JSONSerializeUtils.deserializeFromJSONObject(jsonObj, clazz);
            }
            if (JSONSerializeUtils.isJSON((String)data)) {
                return JSONSerializeUtils.deserializeFromJSON((String)data, clazz);
            }
            if (clazz.isEnum()) {
                return JSONSerializeUtils.deserializeFromJSON("\"" + data + "\"", clazz);
            }
        }
        if (data instanceof JSONString) {
            String jsonStr = ((JSONString)data).toString();
            if (JSONSerializeUtils.isJSON(jsonStr)) {
                return JSONSerializeUtils.deserializeFromJSON(jsonStr, clazz);
            }
            data = jsonStr;
        }
        if (PrimitiveUtils.isPrimitiveType(clazz)) {
            return (T)PrimitiveUtils.castTo((Object)data, clazz);
        }
        if (clazz.isAssignableFrom(data.getClass())) {
            return (T)data;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return (T)data.toString();
        }
        throw new IllegalArgumentException("Unsupported deserialization from type[" + data.getClass().toString() + "] to type[" + clazz.toString() + "]!");
    }
}

