/*
 * Decompiled with CFR 0.152.
 */
package utils.serialize.json;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.spi.Module;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import utils.serialize.json.BeanTypeSerializer;
import utils.serialize.json.ProxyTypeDeserializer;

class ProxyTypeConfigureModule
implements Module {
    public static final ProxyTypeConfigureModule INSTANCE = new ProxyTypeConfigureModule();
    private List<Class<?>> subInterfaces = new ArrayList();
    private Map<Class<?>, ObjectDeserializer> deserializers = new ConcurrentHashMap();
    private Map<Class<?>, ObjectSerializer> serializers = new ConcurrentHashMap();

    private ProxyTypeConfigureModule() {
    }

    public void register(Class<?> ... subInterfaces) {
        for (Class<?> type : subInterfaces) {
            if (type.isInterface()) continue;
            throw new IllegalArgumentException("Type[" + type.getName() + "] is not an interface!");
        }
        for (Class<?> type : subInterfaces) {
            this.subInterfaces.add(type);
        }
    }

    public ObjectDeserializer createDeserializer(ParserConfig config, Class type) {
        ObjectDeserializer deserializer = this.deserializers.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (this.isSubInterface(type)) {
            deserializer = new ProxyTypeDeserializer(type);
            this.deserializers.put(type, deserializer);
            return deserializer;
        }
        return null;
    }

    public ObjectSerializer createSerializer(SerializeConfig config, Class type) {
        Object serializer = this.serializers.get(type);
        if (serializer != null) {
            return serializer;
        }
        Class<?> proxyType = this.getSuperInterface(type);
        if (proxyType != null) {
            serializer = new BeanTypeSerializer(proxyType);
            this.serializers.put(type, (ObjectSerializer)serializer);
            config.put((Type)type, serializer);
            config.put(proxyType, serializer);
            return serializer;
        }
        return null;
    }

    private boolean isSubInterface(Class<?> type) {
        for (Class<?> itf : this.subInterfaces) {
            if (itf != type) continue;
            return true;
        }
        return false;
    }

    private Class<?> getSuperInterface(Class<?> type) {
        for (Class<?> itf : this.subInterfaces) {
            if (!itf.isAssignableFrom(type)) continue;
            return itf;
        }
        return null;
    }
}

