/*
 * Decompiled with CFR 0.152.
 */
package utils.serialize.json;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.spi.Module;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SuperTypeSerializationModule
implements Module {
    public static final SuperTypeSerializationModule INSTANCE = new SuperTypeSerializationModule();
    private Map<Class<?>, ObjectSerializer> supperTypeSerializers = new ConcurrentHashMap();
    private Map<Class<?>, Class<?>> instanceTypeMap = new ConcurrentHashMap();

    private SuperTypeSerializationModule() {
    }

    public ObjectDeserializer createDeserializer(ParserConfig config, Class type) {
        return null;
    }

    public ObjectSerializer createSerializer(SerializeConfig config, Class type) {
        ObjectSerializer serializer = config.get((Type)type);
        if (serializer != null) {
            return serializer;
        }
        serializer = this.supperTypeSerializers.get(type);
        if (serializer != null) {
            return serializer;
        }
        Class<?> superType = this.instanceTypeMap.get(type);
        if (superType != null) {
            return this.supperTypeSerializers.get(superType);
        }
        superType = this.findSuperType(type);
        if (superType != null) {
            this.instanceTypeMap.put(type, superType);
            return this.supperTypeSerializers.get(superType);
        }
        return null;
    }

    private Class<?> findSuperType(Class<?> type) {
        for (Class<?> clazz : this.supperTypeSerializers.keySet()) {
            if (!clazz.isAssignableFrom(type)) continue;
            return clazz;
        }
        return null;
    }

    private Class<?> findAssignableType(Class<?> superType) {
        for (Class<?> clazz : this.supperTypeSerializers.keySet()) {
            if (!superType.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        return null;
    }

    public void registerSuperSerializer(Class<?> superType, ObjectSerializer serializer) {
        Class<?> clazz = this.findSuperType(superType);
        if (clazz != null) {
            throw new IllegalArgumentException(String.format("Super type[%s] of specified type[%s] has been registered!", clazz.getName(), superType.getName()));
        }
        clazz = this.findAssignableType(superType);
        if (clazz != null) {
            throw new IllegalArgumentException(String.format("Subtype[%s] of specified type[%s] has been registered!", clazz.getName(), superType.getName()));
        }
        this.supperTypeSerializers.put(superType, serializer);
    }
}

