/*
 * Decompiled with CFR 0.152.
 */
package com.pili;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.squareup.okhttp.Response;
import java.io.IOException;

public class PiliException
extends Exception {
    public final Response response;
    private String mDetails = null;

    public PiliException(Response response) {
        this.response = response;
        JsonParser parser = new JsonParser();
        try {
            JsonObject jsonObj = parser.parse(response.body().string()).getAsJsonObject();
            this.mDetails = jsonObj.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mDetails = this.mDetails + e.getMessage();
        }
    }

    public PiliException(String msg) {
        super(msg);
        this.response = null;
    }

    public PiliException(Exception e) {
        super(e);
        this.response = null;
    }

    public int code() {
        return this.response == null ? -1 : this.response.code();
    }

    public String getMessage() {
        return this.response == null ? super.getMessage() : this.response.message();
    }

    public String getDetails() {
        return this.mDetails;
    }
}

