/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu;

import common.UrlSafeBase64;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Credentials {
    private static final String DIGEST_AUTH_PREFIX = "Qiniu";
    private SecretKeySpec mSkSpec;
    private String mAccessKey;
    private String mSecretKey;

    public Credentials(String ak, String sk) {
        if (ak == null || sk == null) {
            throw new IllegalArgumentException("Invalid accessKey or secretKey!!");
        }
        this.mAccessKey = ak;
        this.mSecretKey = sk;
        try {
            this.mSkSpec = new SecretKeySpec(this.mSecretKey.getBytes("UTF-8"), "HmacSHA1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String signRequest(URL url, String method, byte[] body, String contentType) throws SignatureException {
        StringBuilder sb = new StringBuilder();
        String line = String.format("%s %s", method, url.getPath());
        sb.append(line);
        if (url.getQuery() != null) {
            sb.append("?" + url.getQuery());
        }
        sb.append(String.format("\nHost: %s", url.getHost()));
        if (url.getPort() > 0) {
            sb.append(String.format(":%d", url.getPort()));
        }
        if (contentType != null) {
            sb.append(String.format("\nContent-Type: %s", contentType));
        }
        sb.append("\n\n");
        if (body != null && contentType != null && !"application/octet-stream".equals(contentType)) {
            sb.append(new String(body));
        }
        return String.format("%s %s:%s", DIGEST_AUTH_PREFIX, this.mAccessKey, this.signData(sb.toString()));
    }

    private static byte[] digest(String secret, String data) throws SignatureException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA1");
            Mac mac = Credentials.createMac(secretKeySpec);
            mac.update(data.getBytes("UTF-8"));
            return mac.doFinal();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureException("Failed to digest: " + e.getMessage());
        }
    }

    public static String sign(String secret, String data) throws SignatureException {
        return UrlSafeBase64.encodeToString(Credentials.digest(secret, data));
    }

    private String signData(String data) throws SignatureException {
        String sign = null;
        try {
            Mac mac = Credentials.createMac(this.mSkSpec);
            sign = UrlSafeBase64.encodeToString(mac.doFinal(data.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return sign;
    }

    private static Mac createMac(SecretKeySpec secretKeySpec) throws GeneralSecurityException {
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKeySpec);
        return mac;
    }
}

