/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform;

import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformFacade;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CloudPlatformAccessor {
    @Nullable
    private static CloudPlatformFacade cloudPlatformFacade = FacadeLocator.getFacade(CloudPlatformFacade.class);

    private static CloudPlatformFacade facade() throws ShouldNotHappenException {
        if (cloudPlatformFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SAP Cloud Platform Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SAP Cloud Platform Neo. Within tests, make sure to declare \"private static final MockUtil mockUtil = new MockUtil();\" in your test class and invoke \"mockUtil.mockDefaults();\" before running the tests.");
        }
        return cloudPlatformFacade;
    }

    public static void setCloudPlatformFacade(@Nonnull CloudPlatformFacade cloudPlatformFacade) {
        CloudPlatformAccessor.cloudPlatformFacade = cloudPlatformFacade;
    }

    @Nonnull
    public static CloudPlatform getCloudPlatform() {
        return CloudPlatformAccessor.facade().getCloudPlatform();
    }

    @Nullable
    public static CloudPlatformFacade getCloudPlatformFacade() {
        return cloudPlatformFacade;
    }
}

