/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.exception;

import java.util.Optional;
import javax.annotation.Nullable;

public class EntityNotFoundException
extends Exception {
    private static final long serialVersionUID = -5891897716381404148L;
    @Nullable
    private String entity = null;

    public Optional<String> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    public EntityNotFoundException() {
        super("Entity not found.");
    }

    public EntityNotFoundException(Class<?> type) {
        super("Entity of type " + type.getSimpleName() + " not found.");
    }

    public <T> EntityNotFoundException(T entity) {
        super("Entity " + entity + " not found.");
    }

    public <T> EntityNotFoundException(T entity, Class<?> type) {
        super("Entity " + entity + " of type " + type.getSimpleName() + " not found.");
        this.entity = entity.toString();
    }
}

