/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.logging;

import com.sap.cloud.sdk.cloudplatform.logging.LogInputSanitizer;
import com.sap.cloud.sdk.cloudplatform.monitoring.ExceptionMonitor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class CloudLoggerFactory {
    private static final Logger log = LoggerFactory.getLogger(CloudLoggerFactory.class);

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls) {
        return new CloudLogger(LoggerFactory.getLogger(cls), false, null);
    }

    @Nonnull
    public static Logger getSanitizedLogger(@Nonnull Class<?> cls) {
        return new CloudLogger(LoggerFactory.getLogger(cls), true, null);
    }

    @Nonnull
    public static Logger getSanitizedLogger(@Nonnull Class<?> cls, @Nullable String endOfLogToken) {
        return new CloudLogger(LoggerFactory.getLogger(cls), true, endOfLogToken);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull String loggerName) {
        return new CloudLogger(LoggerFactory.getLogger((String)loggerName), false, null);
    }

    @Nonnull
    public static Logger getSanitizedLogger(@Nonnull String loggerName) {
        return new CloudLogger(LoggerFactory.getLogger((String)loggerName), true, null);
    }

    @Nonnull
    public static Logger getSanitizedLogger(@Nonnull String loggerName, @Nullable String endOfLogToken) {
        return new CloudLogger(LoggerFactory.getLogger((String)loggerName), true, endOfLogToken);
    }

    static class CloudLogger
    implements Logger {
        private final ExceptionMonitor monitor = ExceptionMonitor.getInstance();
        private final Logger baseLogger;
        @Nullable
        private final LogInputSanitizer sanitizer;

        CloudLogger(@Nonnull Logger baseLogger, boolean useSanitizing, @Nullable String endOfLogToken) {
            this.baseLogger = baseLogger;
            this.sanitizer = useSanitizing ? new LogInputSanitizer(endOfLogToken) : null;
        }

        @Nullable
        private String sanitize(@Nullable String input) {
            if (this.sanitizer != null) {
                return this.sanitizer.sanitizeAndMark(input);
            }
            return input;
        }

        private void record(@Nonnull Throwable throwable) {
            this.monitor.getExceptionTimeVault().recordException(throwable);
        }

        private int getLogLevelOfMarker(@Nullable Marker marker) {
            if (this.baseLogger.isTraceEnabled(marker)) {
                return 0;
            }
            if (this.baseLogger.isDebugEnabled(marker)) {
                return 10;
            }
            if (this.baseLogger.isInfoEnabled(marker)) {
                return 20;
            }
            if (this.baseLogger.isWarnEnabled(marker)) {
                return 30;
            }
            return 40;
        }

        private void log(@Nullable Marker marker, int level, @Nullable String message, @Nullable Object[] args, @Nullable Throwable throwable) {
            int loggerLevel;
            String formattedMessage = message;
            if (args != null && (loggerLevel = this.getLogLevelOfMarker(marker)) <= level) {
                FormattingTuple ft = MessageFormatter.arrayFormat((String)message, (Object[])args);
                formattedMessage = ft.getMessage();
            }
            String sanitizedMessage = this.sanitize(formattedMessage);
            if (this.baseLogger instanceof LocationAwareLogger) {
                ((LocationAwareLogger)this.baseLogger).log(marker, this.getClass().getName(), level, sanitizedMessage, null, throwable);
            } else {
                switch (level) {
                    case 0: {
                        this.baseLogger.trace(marker, sanitizedMessage, throwable);
                        break;
                    }
                    case 10: {
                        this.baseLogger.debug(marker, sanitizedMessage, throwable);
                        break;
                    }
                    case 20: {
                        this.baseLogger.info(marker, sanitizedMessage, throwable);
                        break;
                    }
                    case 30: {
                        this.baseLogger.warn(marker, sanitizedMessage, throwable);
                        break;
                    }
                    case 40: {
                        this.baseLogger.error(marker, sanitizedMessage, throwable);
                        break;
                    }
                    default: {
                        this.baseLogger.error("Failed to correctly write log entry: unknown log level in " + this.getClass() + ". Original log message: " + sanitizedMessage, throwable);
                    }
                }
            }
        }

        public String getName() {
            return this.baseLogger.getName();
        }

        public boolean isTraceEnabled() {
            return this.baseLogger.isTraceEnabled();
        }

        public void trace(String s) {
            this.log(null, 0, s, null, null);
        }

        public void trace(String s, Object o) {
            this.log(null, 0, s, new Object[]{o}, null);
        }

        public void trace(String s, Object o, Object o1) {
            this.log(null, 0, s, new Object[]{o, o1}, null);
        }

        public void trace(String s, Object ... objects) {
            this.log(null, 0, s, objects, null);
        }

        public void trace(String s, Throwable throwable) {
            this.log(null, 0, s, null, throwable);
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.baseLogger.isTraceEnabled(marker);
        }

        public void trace(Marker marker, String s) {
            this.log(marker, 0, s, null, null);
        }

        public void trace(Marker marker, String s, Object o) {
            this.log(marker, 0, s, new Object[]{o}, null);
        }

        public void trace(Marker marker, String s, Object o, Object o1) {
            this.log(marker, 0, s, new Object[]{o, o1}, null);
        }

        public void trace(Marker marker, String s, Object ... objects) {
            this.log(marker, 0, s, objects, null);
        }

        public void trace(Marker marker, String s, Throwable throwable) {
            this.log(marker, 0, s, null, throwable);
        }

        public boolean isDebugEnabled() {
            return this.baseLogger.isDebugEnabled();
        }

        public void debug(String s) {
            this.log(null, 10, s, null, null);
        }

        public void debug(String s, Object o) {
            this.log(null, 10, s, new Object[]{o}, null);
        }

        public void debug(String s, Object o, Object o1) {
            this.log(null, 10, s, new Object[]{o, o1}, null);
        }

        public void debug(String s, Object ... objects) {
            this.log(null, 10, s, objects, null);
        }

        public void debug(String s, Throwable throwable) {
            this.log(null, 10, s, null, throwable);
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.baseLogger.isDebugEnabled(marker);
        }

        public void debug(Marker marker, String s) {
            this.log(marker, 10, s, null, null);
        }

        public void debug(Marker marker, String s, Object o) {
            this.log(marker, 10, s, new Object[]{o}, null);
        }

        public void debug(Marker marker, String s, Object o, Object o1) {
            this.log(marker, 10, s, new Object[]{o, o1}, null);
        }

        public void debug(Marker marker, String s, Object ... objects) {
            this.log(marker, 10, s, objects, null);
        }

        public void debug(Marker marker, String s, Throwable throwable) {
            this.log(marker, 10, s, null, throwable);
        }

        public boolean isInfoEnabled() {
            return this.baseLogger.isInfoEnabled();
        }

        public void info(String s) {
            this.log(null, 20, s, null, null);
        }

        public void info(String s, Object o) {
            this.log(null, 20, s, new Object[]{o}, null);
        }

        public void info(String s, Object o, Object o1) {
            this.log(null, 20, s, new Object[]{o, o1}, null);
        }

        public void info(String s, Object ... objects) {
            this.log(null, 20, s, objects, null);
        }

        public void info(String s, Throwable throwable) {
            this.log(null, 20, s, null, throwable);
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.baseLogger.isInfoEnabled(marker);
        }

        public void info(Marker marker, String s) {
            this.log(marker, 20, s, null, null);
        }

        public void info(Marker marker, String s, Object o) {
            this.log(marker, 20, s, new Object[]{o}, null);
        }

        public void info(Marker marker, String s, Object o, Object o1) {
            this.log(marker, 20, s, new Object[]{o, o1}, null);
        }

        public void info(Marker marker, String s, Object ... objects) {
            this.log(marker, 20, s, objects, null);
        }

        public void info(Marker marker, String s, Throwable throwable) {
            this.log(marker, 20, s, null, throwable);
        }

        public boolean isWarnEnabled() {
            return this.baseLogger.isWarnEnabled();
        }

        public void warn(String s) {
            this.log(null, 30, s, null, null);
        }

        public void warn(String s, Object o) {
            this.log(null, 30, s, new Object[]{o}, null);
        }

        public void warn(String s, Object o, Object o1) {
            this.log(null, 30, s, new Object[]{o, o1}, null);
        }

        public void warn(String s, Object ... objects) {
            this.log(null, 30, s, objects, null);
        }

        public void warn(String s, Throwable throwable) {
            this.log(null, 30, s, null, throwable);
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.baseLogger.isWarnEnabled(marker);
        }

        public void warn(Marker marker, String s) {
            this.log(marker, 30, s, null, null);
        }

        public void warn(Marker marker, String s, Object o) {
            this.log(marker, 30, s, new Object[]{o}, null);
        }

        public void warn(Marker marker, String s, Object o, Object o1) {
            this.log(marker, 30, s, new Object[]{o, o1}, null);
        }

        public void warn(Marker marker, String s, Object ... objects) {
            this.log(marker, 30, s, objects, null);
        }

        public void warn(Marker marker, String s, Throwable throwable) {
            this.log(marker, 30, s, null, throwable);
        }

        public boolean isErrorEnabled() {
            return this.baseLogger.isErrorEnabled();
        }

        public void error(String s) {
            this.log(null, 40, s, null, null);
        }

        public void error(String s, Object o) {
            this.log(null, 40, s, new Object[]{o}, null);
        }

        public void error(String s, Object o, Object o1) {
            this.log(null, 40, s, new Object[]{o, o1}, null);
        }

        public void error(String s, Object ... objects) {
            this.log(null, 40, s, objects, null);
        }

        public void error(String s, Throwable throwable) {
            this.log(null, 40, s, null, throwable);
            this.record(throwable);
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.baseLogger.isErrorEnabled(marker);
        }

        public void error(Marker marker, String s) {
            this.log(marker, 40, s, null, null);
        }

        public void error(Marker marker, String s, Object o) {
            this.log(marker, 40, s, new Object[]{o}, null);
        }

        public void error(Marker marker, String s, Object o, Object o1) {
            this.log(marker, 40, s, new Object[]{o, o1}, null);
        }

        public void error(Marker marker, String s, Object ... objects) {
            this.log(marker, 40, s, objects, null);
        }

        public void error(Marker marker, String s, Throwable throwable) {
            this.log(marker, 40, s, null, throwable);
            this.record(throwable);
        }
    }
}

