/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.logging;

import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class LogInputSanitizer {
    private static final String END_OF_LOG = "(END OF LOG ENTRY)";
    private static final String FORGED = "(MESSAGE MIGHT BE FORGED!)";
    private final String endOfLogToken;
    private final String endOfLogRegex;
    private final Pattern endOfLogPattern;

    public LogInputSanitizer() {
        this(null);
    }

    public LogInputSanitizer(@Nullable String endOfLogToken) {
        this.endOfLogToken = endOfLogToken != null ? endOfLogToken : END_OF_LOG;
        this.endOfLogRegex = Pattern.quote(this.endOfLogToken);
        this.endOfLogPattern = Pattern.compile(this.endOfLogRegex);
    }

    @Nullable
    public String sanitizeAndMark(@Nullable String input) {
        if (input != null && this.endOfLogPattern.matcher(input).find()) {
            return input.replaceAll(this.endOfLogRegex, FORGED);
        }
        return input + " " + this.endOfLogToken;
    }

    public String getEndOfLogToken() {
        return this.endOfLogToken;
    }
}

