/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.monitoring;

import com.google.common.collect.ImmutableList;
import com.sap.cloud.sdk.cloudplatform.monitoring.ExceptionMonitorMXBean;
import com.sap.cloud.sdk.cloudplatform.monitoring.ExceptionTimeVault;
import com.sap.cloud.sdk.cloudplatform.monitoring.JmxMonitor;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;

@WebListener
public class ExceptionMonitor
extends JmxMonitor
implements ExceptionMonitorMXBean {
    private static ExceptionMonitor instance = new ExceptionMonitor();
    private final ExceptionTimeVault exceptionTimeVault = new ExceptionTimeVault(Duration.ofHours(24L));

    public boolean recordException(Throwable throwable) {
        return this.exceptionTimeVault.recordException(throwable);
    }

    public void clear() {
        this.exceptionTimeVault.clear();
    }

    @Override
    public long getTotalNumberOfExceptionsLast01h() {
        return this.exceptionTimeVault.getTotalNumberOfExceptionsForLast(Duration.ofHours(1L));
    }

    @Override
    public long getTotalNumberOfExceptionsLast05h() {
        return this.exceptionTimeVault.getTotalNumberOfExceptionsForLast(Duration.ofHours(5L));
    }

    @Override
    public long getTotalNumberOfExceptionsLast24h() {
        return this.exceptionTimeVault.getTotalNumberOfExceptionsForLast(Duration.ofDays(1L));
    }

    @Override
    public List<String> aggregateTypesOrderedByFrequency() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<Integer, String> e : this.exceptionTimeVault.aggregateTypesOrderedByFrequencyAsSortedMap().entrySet()) {
            builder.add((Object)(e.getKey() + " => " + e.getValue()));
        }
        return builder.build();
    }

    @Override
    public List<String> dump() {
        return this.exceptionTimeVault.dump();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        instance.registerJmxBean();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        instance.unregisterJmxBean();
    }

    public static ExceptionMonitor getInstance() {
        return instance;
    }

    public static void setInstance(ExceptionMonitor instance) {
        ExceptionMonitor.instance = instance;
    }

    public ExceptionTimeVault getExceptionTimeVault() {
        return this.exceptionTimeVault;
    }
}

