/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.monitoring;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class ExceptionTimeVault {
    private Duration preservationDuration;
    private final ConcurrentSkipListSet<AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable>> timestampedThrowables;
    private final WeakHashMap<Throwable, Object> weakThrowableSet = new WeakHashMap();

    public ExceptionTimeVault(Duration preservationDuration) {
        this.preservationDuration = preservationDuration;
        this.timestampedThrowables = new ConcurrentSkipListSet(new NaturalKeyOrderComparator());
    }

    private NavigableSet<AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable>> getEntriesAfter(ZonedDateTime cutoffTime) {
        AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable> cutoffEntry = this.createCutoffEntry(cutoffTime);
        return this.timestampedThrowables.tailSet(cutoffEntry, false);
    }

    private NavigableSet<AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable>> getEntriesBefore(ZonedDateTime cutoffTime) {
        AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable> cutoffEntry = this.createCutoffEntry(cutoffTime);
        return this.timestampedThrowables.headSet(cutoffEntry, true);
    }

    private AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable> createCutoffEntry(ZonedDateTime cutOffTime) {
        return new AbstractMap.SimpleImmutableEntry<ZonedDateTime, Object>(cutOffTime, null);
    }

    public SortedMap<Integer, String> aggregateTypesOrderedByFrequencyAsSortedMap() {
        this.cleanUpOldExceptions();
        HashMultiset classes = HashMultiset.create();
        for (AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable> entry : this.timestampedThrowables) {
            classes.add(entry.getValue().getClass());
        }
        TreeMap sortedMap = Maps.newTreeMap();
        for (Class cls : classes.elementSet()) {
            sortedMap.put(classes.count((Object)cls), cls.getCanonicalName());
        }
        return sortedMap.descendingMap();
    }

    public List<String> dump() {
        this.cleanUpOldExceptions();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable> entry : this.timestampedThrowables) {
            builder.add((Object)(entry.getKey() + "   " + entry.getValue()));
        }
        return builder.build();
    }

    int getNumberOfWeakEntries() {
        return this.weakThrowableSet.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recordException(Throwable throwable) {
        this.cleanUpOldExceptions();
        AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable> newEntry = new AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable>(ZonedDateTime.now(), throwable);
        WeakHashMap<Throwable, Object> weakHashMap = this.weakThrowableSet;
        synchronized (weakHashMap) {
            if (this.weakThrowableSet.containsKey(throwable)) {
                return false;
            }
            this.weakThrowableSet.put(throwable, 1);
        }
        return this.timestampedThrowables.add(newEntry);
    }

    private int cleanUpOldExceptions() {
        ZonedDateTime cutoffTime = ZonedDateTime.now().minus(this.preservationDuration);
        NavigableSet<AbstractMap.SimpleImmutableEntry<ZonedDateTime, Throwable>> entriesToDelete = this.getEntriesBefore(cutoffTime);
        this.timestampedThrowables.removeAll(entriesToDelete);
        return entriesToDelete.size();
    }

    public void clear() {
        this.timestampedThrowables.clear();
        this.weakThrowableSet.clear();
    }

    public long getTotalNumberOfExceptionsForLast(Duration duration) {
        return this.getEntriesAfter(ZonedDateTime.now().minus(duration)).size();
    }

    public void setPreservationDuration(Duration preservationDuration) {
        this.preservationDuration = preservationDuration;
    }

    private static class NaturalKeyOrderComparator<T extends Comparable<? super T>>
    implements Comparator<AbstractMap.SimpleImmutableEntry<T, Throwable>> {
        private NaturalKeyOrderComparator() {
        }

        @Override
        public int compare(AbstractMap.SimpleImmutableEntry<T, Throwable> o1, AbstractMap.SimpleImmutableEntry<T, Throwable> o2) {
            int dateCompareResult = ((Comparable)o1.getKey()).compareTo(o2.getKey());
            if (dateCompareResult == 0) {
                boolean valuesEqual = o1.getValue() == o2.getValue();
                return valuesEqual ? 0 : -1;
            }
            return dateCompareResult;
        }
    }
}

