/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.monitoring;

import java.lang.management.ManagementFactory;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JmxMonitor
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(JmxMonitor.class);
    @Nullable
    private ObjectName objectName = null;

    private String getMonitorName() {
        return this.getClass().getPackage().getName() + ":name=" + this.getClass().getSimpleName();
    }

    public void registerJmxBean() {
        String monitorName = this.getMonitorName();
        logger.info("Registering JMX bean for monitor " + monitorName + ".");
        try {
            this.objectName = new ObjectName(monitorName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, this.objectName);
            if (logger.isInfoEnabled()) {
                logger.info("Successfully registered JMX bean " + this.objectName + ".");
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            logger.error("Failed to register JMX bean of " + this.getClass().getName() + ".", (Throwable)e);
        }
    }

    public void unregisterJmxBean() {
        String monitorName = this.getMonitorName();
        logger.info("Unregistering JMX bean for monitor " + monitorName + ".");
        if (this.objectName == null) {
            logger.warn("Failed to unregister JMX bean for monitor " + monitorName + ": object name is null.");
            return;
        }
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.objectName);
            if (logger.isInfoEnabled()) {
                logger.info("Successfully unregistered JMX bean " + this.objectName + ".");
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            logger.error("Failed to unregister JMX bean of " + monitorName + ".", (Throwable)e);
        }
    }
}

