/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.naming;

import com.sap.cloud.sdk.cloudplatform.exception.ObjectLookupFailedException;
import javax.annotation.Nonnull;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JndiLookupFacade {
    private String getExceptionMessage(String name) {
        return "Failed to look up object with name \"" + name + "\". This usually indicates a misconfiguration related to JNDI (for example, a missing resource reference).";
    }

    @Nonnull
    public Object lookup(@Nonnull String name) throws ObjectLookupFailedException {
        Object result;
        try {
            InitialContext ctx = new InitialContext();
            result = ctx.lookup(name);
        }
        catch (NamingException e) {
            throw new ObjectLookupFailedException(this.getExceptionMessage(name), e);
        }
        if (result == null) {
            throw new ObjectLookupFailedException(this.getExceptionMessage(name));
        }
        return result;
    }
}

