/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.util;

import com.sap.cloud.sdk.cloudplatform.exception.ObjectLookupFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FacadeLocator {
    public static final String UNKNOWN_CLOUD_PLATFORM_MESSAGE = "Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SAP Cloud Platform Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SAP Cloud Platform Neo. Within tests, make sure to declare \"private static final MockUtil mockUtil = new MockUtil();\" in your test class and invoke \"mockUtil.mockDefaults();\" before running the tests.";
    private static MockableInstance mockableInstance = new MockableInstance();

    public static MockableInstance getMockableInstance() {
        return mockableInstance;
    }

    public static void setMockableInstance(MockableInstance mockableInstance) {
        FacadeLocator.mockableInstance = mockableInstance;
    }

    @Nonnull
    public static <FacadeT> Collection<FacadeT> getFacades(Class<FacadeT> facadeInterface) {
        return mockableInstance.getFacades(facadeInterface);
    }

    @Nullable
    public static <FacadeT> FacadeT getFacade(Class<FacadeT> facadeInterface) throws ObjectLookupFailedException {
        return mockableInstance.getFacade(facadeInterface);
    }

    public static class MockableInstance {
        private final ClassLoader classLoader = MockableInstance.class.getClassLoader();

        @Nonnull
        public <FacadeT> Collection<FacadeT> getFacades(Class<FacadeT> facadeInterface) {
            ServiceLoader<FacadeT> serviceLoader = ServiceLoader.load(facadeInterface, this.classLoader);
            Iterator<FacadeT> serviceIt = serviceLoader.iterator();
            ArrayList<FacadeT> facades = new ArrayList<FacadeT>();
            while (serviceIt.hasNext()) {
                facades.add(serviceIt.next());
            }
            return facades;
        }

        @Nullable
        public <FacadeT> FacadeT getFacade(Class<FacadeT> facadeInterface) throws ObjectLookupFailedException {
            ServiceLoader<FacadeT> serviceLoader = ServiceLoader.load(facadeInterface, this.classLoader);
            Iterator<FacadeT> serviceIt = serviceLoader.iterator();
            if (serviceIt.hasNext()) {
                FacadeT facade = serviceIt.next();
                if (serviceIt.hasNext()) {
                    throw new ObjectLookupFailedException("Found multiple implementations of " + facadeInterface.getSimpleName() + ": " + this.getFacades(facadeInterface) + ". Make sure to only specify one implementation in META-INF/services/" + facadeInterface.getName() + ".");
                }
                return facade;
            }
            return null;
        }
    }
}

