/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.util;

import com.sap.cloud.sdk.cloudplatform.exception.StringParsingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javax.annotation.Nullable;

public final class StringConverter {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    @Nullable
    public static String toString(@Nullable Date d) {
        if (d == null) {
            return null;
        }
        return new SimpleDateFormat(DATE_PATTERN).format(d);
    }

    @Nullable
    public static Date toDate(@Nullable String s) throws StringParsingException {
        return StringConverter.toDate(s, DATE_PATTERN);
    }

    @Nullable
    public static Date toDate(@Nullable String s, String pattern) throws StringParsingException {
        if (s == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(pattern).parse(s);
        }
        catch (ParseException e) {
            throw new StringParsingException(s, LocalDate.class, e);
        }
    }

    @Nullable
    public static String toString(@Nullable LocalDate d) {
        return StringConverter.toString(d, DATE_PATTERN);
    }

    @Nullable
    public static String toString(@Nullable LocalDate d, String pattern) {
        if (d == null) {
            return null;
        }
        return d.format(DateTimeFormatter.ofPattern(pattern));
    }

    @Nullable
    public static LocalDate toLocalDate(@Nullable String s) throws StringParsingException {
        return StringConverter.toLocalDate(s, DATE_PATTERN);
    }

    @Nullable
    public static LocalDate toLocalDate(@Nullable String s, String pattern) throws StringParsingException {
        if (s == null) {
            return null;
        }
        try {
            return LocalDate.parse(s, DateTimeFormatter.ofPattern(pattern));
        }
        catch (DateTimeParseException e) {
            throw new StringParsingException(s, LocalDate.class, e);
        }
    }

    @Nullable
    public static String toString(@Nullable LocalDateTime dt) {
        return StringConverter.toString(dt, DATE_TIME_PATTERN);
    }

    @Nullable
    public static String toString(@Nullable LocalDateTime dt, String pattern) {
        if (dt == null) {
            return null;
        }
        return dt.format(DateTimeFormatter.ofPattern(pattern));
    }

    @Nullable
    public static LocalDateTime toLocalDateTime(@Nullable String s) throws StringParsingException {
        return StringConverter.toLocalDateTime(s, DATE_TIME_PATTERN);
    }

    @Nullable
    public static LocalDateTime toLocalDateTime(@Nullable String s, String pattern) throws StringParsingException {
        if (s == null) {
            return null;
        }
        try {
            return LocalDateTime.parse(s, DateTimeFormatter.ofPattern(pattern));
        }
        catch (DateTimeParseException e) {
            throw new StringParsingException(s, LocalDateTime.class, e);
        }
    }
}

