/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOInputStreamAdapter;
import com.twelvemonkeys.imageio.util.IIOOutputStreamAdapter;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.IIOParam;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IIOUtil {
    private IIOUtil() {
    }

    public static InputStream createStreamAdapter(ImageInputStream pStream) {
        return new BufferedInputStream(new IIOInputStreamAdapter(pStream));
    }

    public static InputStream createStreamAdapter(ImageInputStream pStream, long pLength) {
        return new BufferedInputStream(new IIOInputStreamAdapter(pStream, pLength));
    }

    public static OutputStream createStreamAdapter(ImageOutputStream pStream) {
        return new BufferedOutputStream(new IIOOutputStreamAdapter(pStream));
    }

    public static Image fakeSubsampling(Image pImage, IIOParam pParam) {
        if (pImage == null) {
            return null;
        }
        if (pParam != null) {
            int x = pParam.getSourceXSubsampling();
            int y = pParam.getSourceYSubsampling();
            if (x > 1 || y > 1) {
                int w = (ImageUtil.getWidth((Image)pImage) + x - 1) / x;
                int h = (ImageUtil.getHeight((Image)pImage) + y - 1) / y;
                return pImage.getScaledInstance(w, h, 2);
            }
        }
        return pImage;
    }

    public static Rectangle getSourceRegion(IIOParam pParam, int pSrcWidth, int pSrcHeight) {
        Rectangle sourceRegion = new Rectangle(pSrcWidth, pSrcHeight);
        if (pParam != null) {
            Rectangle region = pParam.getSourceRegion();
            if (region != null) {
                sourceRegion = sourceRegion.intersection(region);
            }
            int subsampleXOffset = pParam.getSubsamplingXOffset();
            int subsampleYOffset = pParam.getSubsamplingYOffset();
            sourceRegion.x += subsampleXOffset;
            sourceRegion.y += subsampleYOffset;
            sourceRegion.width -= subsampleXOffset;
            sourceRegion.height -= subsampleYOffset;
        }
        return sourceRegion;
    }

    public static BufferedImage fakeAOI(BufferedImage pImage, Rectangle pSourceRegion) {
        if (pImage == null) {
            return null;
        }
        if (pSourceRegion != null && (pSourceRegion.x != 0 || pSourceRegion.y != 0 || pSourceRegion.width != pImage.getWidth() || pSourceRegion.height != pImage.getHeight())) {
            return pImage.getSubimage(pSourceRegion.x, pSourceRegion.y, pSourceRegion.width, pSourceRegion.height);
        }
        return pImage;
    }

    public static ProviderInfo getProviderInfo(Class<? extends IIOServiceProvider> pProviderClass) {
        return new ProviderInfo(pProviderClass.getPackage());
    }

    public static <T> void deregisterProvider(ServiceRegistry pRegistry, IIOServiceProvider pProvider, Class<T> pCategory) {
        pRegistry.deregisterServiceProvider(pCategory.cast(pProvider), pCategory);
    }
}

