/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchResultReferenceProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -1526778443581862609L;
    private final List<String> referralURLs;

    public SearchResultReferenceProtocolOp(List<String> referralURLs) {
        this.referralURLs = Collections.unmodifiableList(referralURLs);
    }

    SearchResultReferenceProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            ArrayList<String> refs = new ArrayList<String>(5);
            ASN1StreamReaderSequence refSequence = reader.beginSequence();
            while (refSequence.hasMoreElements()) {
                refs.add(reader.readString());
            }
            this.referralURLs = Collections.unmodifiableList(refs);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_SEARCH_REFERENCE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public byte getProtocolOpType() {
        return 115;
    }

    @Override
    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)115);
        for (String s : this.referralURLs) {
            buffer.addOctetString(s);
        }
        opSequence.end();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchResultReferenceProtocolOp(referralURLs={");
        Iterator<String> iterator = this.referralURLs.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("})");
    }
}

