/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc;

import io.github.yezhihao.netmc.NettyConfig;
import io.github.yezhihao.netmc.codec.DelimiterBasedFrameDecoder;
import io.github.yezhihao.netmc.codec.LengthFieldAndDelimiterFrameDecoder;
import io.github.yezhihao.netmc.codec.MessageDecoderWrapper;
import io.github.yezhihao.netmc.codec.MessageEncoderWrapper;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPServer {
    private static final Logger log = LoggerFactory.getLogger(TCPServer.class);
    private volatile boolean isRunning = false;
    private EventLoopGroup bossGroup = null;
    private EventLoopGroup workerGroup = null;
    private String name;
    private NettyConfig config;

    public TCPServer(String name, NettyConfig config) {
        this.name = name;
        this.config = config;
    }

    private void startInternal() {
        try {
            this.bossGroup = new NioEventLoopGroup(1);
            this.workerGroup = new NioEventLoopGroup(NettyRuntime.availableProcessors());
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.channel(NioServerSocketChannel.class);
            bootstrap.group(this.bossGroup, this.workerGroup);
            ((ServerBootstrap)((ServerBootstrap)bootstrap.option(NioChannelOption.SO_BACKLOG, (Object)1024)).option(NioChannelOption.SO_REUSEADDR, (Object)true)).childOption(NioChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){
                private MessageEncoderWrapper messageEncoderWrapper;
                private MessageDecoderWrapper messageDecoderWrapper;
                {
                    this.messageEncoderWrapper = new MessageEncoderWrapper(((TCPServer)TCPServer.this).config.encoder);
                    this.messageDecoderWrapper = new MessageDecoderWrapper(((TCPServer)TCPServer.this).config.decoder);
                }

                public void initChannel(NioSocketChannel channel) {
                    channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(4L, 0L, 0L, TimeUnit.MINUTES)}).addLast("frameDecoder", (ChannelHandler)TCPServer.this.frameDecoder()).addLast("decoder", (ChannelHandler)this.messageDecoderWrapper).addLast("encoder", (ChannelHandler)this.messageEncoderWrapper).addLast("adapter", (ChannelHandler)((TCPServer)TCPServer.this).config.adapter);
                }
            });
            ChannelFuture channelFuture = bootstrap.bind(this.config.port).sync();
            log.warn("==={}\u542f\u52a8\u6210\u529f, port={}===", (Object)this.name, (Object)this.config.port);
            channelFuture.channel().closeFuture().sync();
        }
        catch (Exception e) {
            log.warn("==={}\u51fa\u73b0\u5f02\u5e38, port={}===", (Throwable)e);
        }
        finally {
            this.stop();
        }
    }

    public ByteToMessageDecoder frameDecoder() {
        if (this.config.lengthField == null) {
            return new DelimiterBasedFrameDecoder(this.config.maxFrameLength, this.config.delimiter);
        }
        return new LengthFieldAndDelimiterFrameDecoder(this.config.maxFrameLength, this.config.lengthField, this.config.delimiter);
    }

    public synchronized void start() {
        if (this.isRunning) {
            log.warn("==={}\u5df2\u7ecf\u542f\u52a8, port={}===", (Object)this.name, (Object)this.config.port);
            return;
        }
        this.isRunning = true;
        new Thread(() -> this.startInternal()).start();
    }

    public synchronized void stop() {
        if (!this.isRunning) {
            log.warn("==={}\u5df2\u7ecf\u505c\u6b62, port={}===", (Object)this.name, (Object)this.config.port);
        }
        this.isRunning = false;
        Future future = this.bossGroup.shutdownGracefully();
        if (!future.isSuccess()) {
            log.warn("bossGroup \u65e0\u6cd5\u6b63\u5e38\u505c\u6b62", future.cause());
        }
        if (!(future = this.workerGroup.shutdownGracefully()).isSuccess()) {
            log.warn("workerGroup \u65e0\u6cd5\u6b63\u5e38\u505c\u6b62", future.cause());
        }
        log.warn("==={}\u5df2\u7ecf\u505c\u6b62, port={}===", (Object)this.name, (Object)this.config.port);
    }
}

