/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc;

import io.github.yezhihao.netmc.core.HandlerInterceptor;
import io.github.yezhihao.netmc.core.HandlerMapping;
import io.github.yezhihao.netmc.core.handler.Handler;
import io.github.yezhihao.netmc.core.model.Message;
import io.github.yezhihao.netmc.session.Session;
import io.github.yezhihao.netmc.session.SessionManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class TCPServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger((String)TCPServerHandler.class.getSimpleName());
    private HandlerMapping handlerMapping;
    private HandlerInterceptor interceptor;
    private SessionManager sessionManager;

    public TCPServerHandler(HandlerMapping handlerMapping, HandlerInterceptor interceptor, SessionManager sessionManager) {
        this.handlerMapping = handlerMapping;
        this.interceptor = interceptor;
        this.sessionManager = sessionManager;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Message response;
        if (!(msg instanceof Message)) {
            return;
        }
        Message request = (Message)msg;
        Channel channel = ctx.channel();
        Session session = (Session)channel.attr(Session.KEY).get();
        long time = session.access();
        try {
            Handler handler = this.handlerMapping.getHandler(request.getMessageType());
            if (handler != null) {
                if (!this.interceptor.beforeHandle(request, session)) {
                    return;
                }
                response = handler.invoke(request, session);
                if (handler.returnVoid) {
                    response = this.interceptor.successful(request, session);
                } else {
                    this.interceptor.afterHandle(request, response, session);
                }
            } else {
                response = this.interceptor.notSupported(request, session);
            }
        }
        catch (Exception e) {
            log.warn(String.valueOf(request), (Throwable)e);
            response = this.interceptor.exceptional(request, session, e);
        }
        time = System.currentTimeMillis() - time;
        if (time > 200L) {
            log.info("=========\u6d88\u606fID{},\u5904\u7406\u8017\u65f6{}ms,", request.getHeader(), (Object)time);
        }
        if (response != null) {
            ctx.writeAndFlush((Object)response);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        Session session = this.sessionManager.newSession(channel);
        channel.attr(Session.KEY).set((Object)session);
        log.info(">>>>>\u7ec8\u7aef\u8fde\u63a5{}", (Object)session);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Session session = (Session)ctx.channel().attr(Session.KEY).get();
        session.invalidate();
        log.info("<<<<<\u65ad\u5f00\u8fde\u63a5{}", (Object)session);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        Session session = (Session)ctx.channel().attr(Session.KEY).get();
        log.warn("<<<<<\u6d88\u606f\u5904\u7406\u5f02\u5e38" + session, e);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent event;
        IdleState state;
        if (evt instanceof IdleStateEvent && ((state = (event = (IdleStateEvent)evt).state()) == IdleState.READER_IDLE || state == IdleState.WRITER_IDLE)) {
            Session session = (Session)ctx.channel().attr(Session.KEY).get();
            log.warn("<<<<<\u7ec8\u7aef\u4e3b\u52a8\u65ad\u5f00\u8fde\u63a5{}", (Object)session);
            ctx.close();
        }
    }
}

