/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.codec;

import io.netty.util.internal.ObjectUtil;

public class LengthField {
    protected final byte[] prefix;
    protected final int lengthFieldMaxFrameLength;
    protected final int lengthFieldOffset;
    protected final int lengthFieldLength;
    protected final int lengthFieldEndOffset;
    protected final int lengthAdjustment;
    protected final int initialBytesToStrip;

    public LengthField(byte[] prefix, int maxFrameLength, int lengthFieldOffset, int lengthFieldLength) {
        this(prefix, maxFrameLength, lengthFieldOffset, lengthFieldLength, 0, 0);
    }

    public LengthField(byte[] prefix, int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip) {
        ObjectUtil.checkPositive((int)maxFrameLength, (String)"maxFrameLength_LengthField");
        ObjectUtil.checkPositiveOrZero((int)lengthFieldOffset, (String)"lengthFieldOffset");
        ObjectUtil.checkPositiveOrZero((int)initialBytesToStrip, (String)"initialBytesToStrip");
        if (lengthFieldOffset > maxFrameLength - lengthFieldLength) {
            throw new IllegalArgumentException("maxFrameLength_LengthField (" + maxFrameLength + ") must be equal to or greater than lengthFieldOffset (" + lengthFieldOffset + ") + lengthFieldLength (" + lengthFieldLength + ").");
        }
        this.prefix = prefix;
        this.lengthFieldMaxFrameLength = maxFrameLength;
        this.lengthFieldOffset = lengthFieldOffset;
        this.lengthFieldLength = lengthFieldLength;
        this.lengthAdjustment = lengthAdjustment;
        this.lengthFieldEndOffset = lengthFieldOffset + lengthFieldLength;
        this.initialBytesToStrip = initialBytesToStrip;
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    public int getLengthFieldMaxFrameLength() {
        return this.lengthFieldMaxFrameLength;
    }

    public int getLengthFieldOffset() {
        return this.lengthFieldOffset;
    }

    public int getLengthFieldLength() {
        return this.lengthFieldLength;
    }

    public int getLengthFieldEndOffset() {
        return this.lengthFieldEndOffset;
    }

    public int getLengthAdjustment() {
        return this.lengthAdjustment;
    }

    public int getInitialBytesToStrip() {
        return this.initialBytesToStrip;
    }
}

