/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.codec;

import io.github.yezhihao.netmc.codec.Delimiter;
import io.github.yezhihao.netmc.codec.DelimiterBasedFrameDecoder;
import io.github.yezhihao.netmc.codec.LengthField;
import io.github.yezhihao.netmc.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class LengthFieldAndDelimiterFrameDecoder
extends DelimiterBasedFrameDecoder {
    protected final byte[] prefix;
    private final int maxFrameLength;
    private final int lengthFieldOffset;
    private final int lengthFieldLength;
    private final int lengthFieldEndOffset;
    private final int lengthAdjustment;
    private final int initialBytesToStrip;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private int tooLongFrameLength;
    private int bytesToDiscard;

    public LengthFieldAndDelimiterFrameDecoder(int maxFrameLength, LengthField lengthField, Delimiter ... delimiters) {
        this(maxFrameLength, true, lengthField, delimiters);
    }

    public LengthFieldAndDelimiterFrameDecoder(int maxFrameLength, boolean failFast, LengthField lengthField, Delimiter ... delimiters) {
        super(maxFrameLength, failFast, delimiters);
        ObjectUtil.checkPositive((int)maxFrameLength, (String)"delimiterMaxFrameLength");
        ObjectUtil.checkNonEmpty((Object[])delimiters, (String)"delimiters");
        this.prefix = lengthField.prefix;
        this.maxFrameLength = lengthField.lengthFieldMaxFrameLength;
        this.lengthFieldOffset = lengthField.lengthFieldOffset;
        this.lengthFieldLength = lengthField.lengthFieldLength;
        this.lengthFieldEndOffset = lengthField.lengthFieldEndOffset;
        this.lengthAdjustment = lengthField.lengthAdjustment;
        this.initialBytesToStrip = lengthField.initialBytesToStrip;
        this.failFast = failFast;
    }

    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Object decoded;
        if (this.discardingTooLongFrame) {
            this.discardingTooLongFrame(in);
        }
        if ((decoded = ByteBufUtils.startsWith(in, this.prefix) ? this.decode(ctx, in) : super.decode(ctx, in)) != null) {
            out.add(decoded);
        }
    }

    private void discardingTooLongFrame(ByteBuf in) {
        int bytesToDiscard = this.bytesToDiscard;
        int localBytesToDiscard = Math.min(bytesToDiscard, in.readableBytes());
        in.skipBytes(localBytesToDiscard);
        this.bytesToDiscard = bytesToDiscard -= localBytesToDiscard;
        this.failIfNecessary(false);
    }

    private static void failOnNegativeLengthField(ByteBuf in, int frameLength, int lengthFieldEndOffset) {
        in.skipBytes(lengthFieldEndOffset);
        throw new CorruptedFrameException("negative pre-adjustment length field: " + frameLength);
    }

    private static void failOnFrameLengthLessThanLengthFieldEndOffset(ByteBuf in, int frameLength, int lengthFieldEndOffset) {
        in.skipBytes(lengthFieldEndOffset);
        throw new CorruptedFrameException("Adjusted frame length (" + frameLength + ") is less than lengthFieldEndOffset: " + lengthFieldEndOffset);
    }

    private void exceededFrameLength(ByteBuf in, int frameLength) {
        int discard = frameLength - in.readableBytes();
        this.tooLongFrameLength = frameLength;
        if (discard < 0) {
            in.skipBytes(frameLength);
        } else {
            this.discardingTooLongFrame = true;
            this.bytesToDiscard = discard;
            in.skipBytes(in.readableBytes());
        }
        this.failIfNecessary(true);
    }

    private static void failOnFrameLengthLessThanInitialBytesToStrip(ByteBuf in, int frameLength, int initialBytesToStrip) {
        in.skipBytes(frameLength);
        throw new CorruptedFrameException("Adjusted frame length (" + frameLength + ") is less than initialBytesToStrip: " + initialBytesToStrip);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (in.readableBytes() < this.lengthFieldEndOffset) {
            return null;
        }
        int actualLengthFieldOffset = in.readerIndex() + this.lengthFieldOffset;
        int frameLength = this.getUnadjustedFrameLength(in, actualLengthFieldOffset, this.lengthFieldLength);
        if (frameLength < 0) {
            LengthFieldAndDelimiterFrameDecoder.failOnNegativeLengthField(in, frameLength, this.lengthFieldEndOffset);
        }
        if ((frameLength += this.lengthAdjustment + this.lengthFieldEndOffset) < this.lengthFieldEndOffset) {
            LengthFieldAndDelimiterFrameDecoder.failOnFrameLengthLessThanLengthFieldEndOffset(in, frameLength, this.lengthFieldEndOffset);
        }
        if (frameLength > this.maxFrameLength) {
            this.exceededFrameLength(in, frameLength);
            return null;
        }
        if (in.readableBytes() < frameLength) {
            return null;
        }
        if (this.initialBytesToStrip > frameLength) {
            LengthFieldAndDelimiterFrameDecoder.failOnFrameLengthLessThanInitialBytesToStrip(in, frameLength, this.initialBytesToStrip);
        }
        in.skipBytes(this.initialBytesToStrip);
        int readerIndex = in.readerIndex();
        int actualFrameLength = frameLength - this.initialBytesToStrip;
        ByteBuf frame = in.retainedSlice(readerIndex, actualFrameLength);
        in.readerIndex(readerIndex + actualFrameLength);
        return frame;
    }

    protected int getUnadjustedFrameLength(ByteBuf buf, int offset, int length) {
        int frameLength;
        switch (length) {
            case 2: {
                frameLength = buf.getUnsignedShort(offset);
                break;
            }
            case 3: {
                frameLength = buf.getUnsignedMedium(offset);
                break;
            }
            case 4: {
                frameLength = buf.getInt(offset);
                break;
            }
            default: {
                throw new DecoderException("unsupported lengthFieldLength: " + this.lengthFieldLength + " (expected:  2, 3, 4)");
            }
        }
        return frameLength;
    }

    private void failIfNecessary(boolean firstDetectionOfTooLongFrame) {
        if (this.bytesToDiscard == 0) {
            int tooLongFrameLength = this.tooLongFrameLength;
            this.tooLongFrameLength = 0;
            this.discardingTooLongFrame = false;
            if (!this.failFast || firstDetectionOfTooLongFrame) {
                this.fail(tooLongFrameLength);
            }
        } else if (this.failFast && firstDetectionOfTooLongFrame) {
            this.fail(this.tooLongFrameLength);
        }
    }

    private void fail(long frameLength) {
        if (frameLength > 0L) {
            throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + ": " + frameLength + " - discarded");
        }
        throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + " - discarding");
    }
}

