/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.codec;

import io.github.yezhihao.netmc.codec.MessageDecoder;
import io.github.yezhihao.netmc.session.Session;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MessageDecoderWrapper
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger((String)MessageDecoderWrapper.class.getSimpleName());
    private MessageDecoder decoder;

    public MessageDecoderWrapper(MessageDecoder decoder) {
        this.decoder = decoder;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            try {
                Object message;
                if (log.isInfoEnabled()) {
                    String hex = buf.readableBytes() < 1048 ? ByteBufUtil.hexDump((ByteBuf)buf) : ByteBufUtil.hexDump((ByteBuf)buf.slice(0, 32)) + "..." + ByteBufUtil.hexDump((ByteBuf)buf.slice(buf.readableBytes() - 32, 32));
                    log.info(">>>>>\u539f\u59cb\u62a5\u6587[ip={}],hex={}", (Object)ctx.channel().remoteAddress(), (Object)hex);
                }
                if ((message = this.decoder.decode(buf, (Session)ctx.channel().attr(Session.KEY).get())) != null) {
                    ctx.fireChannelRead(message);
                }
                buf.skipBytes(buf.readableBytes());
            }
            catch (Exception e) {
                throw new DecoderException((Throwable)e);
            }
            finally {
                buf.release();
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }
}

