/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.codec;

import io.github.yezhihao.netmc.codec.MessageEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MessageEncoderWrapper
extends ChannelOutboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger((String)MessageEncoderWrapper.class.getSimpleName());
    private MessageEncoder encoder;

    public MessageEncoderWrapper(MessageEncoder encoder) {
        this.encoder = encoder;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ByteBuf buf = null;
        try {
            buf = this.encoder.encode(msg);
            if (log.isInfoEnabled()) {
                log.info("<<<<<\u539f\u59cb\u62a5\u6587[ip={}],hex={}", (Object)ctx.channel().remoteAddress(), (Object)ByteBufUtil.hexDump((ByteBuf)buf));
            }
            if (buf.isReadable()) {
                ctx.write((Object)buf, promise);
            } else {
                buf.release();
                ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
            }
            buf = null;
        }
        catch (EncoderException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EncoderException(e);
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
    }
}

