/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.core.handler;

import io.github.yezhihao.netmc.core.handler.Handler;
import io.github.yezhihao.netmc.core.model.Message;
import io.github.yezhihao.netmc.session.Session;
import io.github.yezhihao.netmc.util.BasicThreadFactory;
import io.github.yezhihao.netmc.util.VirtualList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBatchHandler
extends Handler {
    private static final Logger log = LoggerFactory.getLogger((String)AsyncBatchHandler.class.getSimpleName());
    private ConcurrentLinkedQueue<Message> queue;
    private ThreadPoolExecutor executor;
    private int poolSize;
    private int maxElements;
    private int maxWait;
    private int warningLines;

    public AsyncBatchHandler(Object actionClass, Method actionMethod, String desc, int poolSize, int maxElements, int maxWait) {
        super(actionClass, actionMethod, desc);
        Class<?>[] parameterTypes = actionMethod.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new RuntimeException("@AsyncBatch\u65b9\u6cd5\u4ec5\u652f\u6301\u4e00\u4e2aList\u53c2\u6570:" + actionMethod);
        }
        if (!parameterTypes[0].isAssignableFrom(List.class)) {
            throw new RuntimeException("@AsyncBatch\u65b9\u6cd5\u7684\u53c2\u6570\u4e0d\u662fList\u7c7b\u578b:" + actionMethod);
        }
        this.poolSize = poolSize;
        this.maxElements = maxElements;
        this.maxWait = maxWait;
        this.warningLines = maxElements * poolSize * 50;
        this.queue = new ConcurrentLinkedQueue();
        this.executor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(400), new BasicThreadFactory.Builder().daemon(true).namingPattern(actionMethod.getName() + "-pool-%d").build());
        for (int i = 0; i < poolSize; ++i) {
            boolean master = i == 0;
            this.executor.execute(() -> {
                try {
                    this.startInternal(master);
                }
                catch (Exception e) {
                    log.error("\u6279\u5904\u7406\u7ebf\u7a0b\u51fa\u9519", (Throwable)e);
                }
            });
        }
    }

    public Message invoke(Message request, Session session) {
        this.queue.offer(request);
        return null;
    }

    public void startInternal(boolean master) {
        Message[] array = new Message[this.maxElements];
        long logtime = 0L;
        long starttime = 0L;
        while (true) {
            Message temp;
            int i = 0;
            while ((temp = this.queue.poll()) != null) {
                array[i++] = temp;
                if (i < this.maxElements) continue;
            }
            if (i > 0) {
                starttime = System.currentTimeMillis();
                try {
                    this.targetMethod.invoke(this.targetObject, new VirtualList<Message>(array, i));
                }
                catch (Exception e) {
                    log.warn(this.targetMethod.getName(), (Throwable)e);
                }
                long time = System.currentTimeMillis() - starttime;
                if (time > 1000L) {
                    log.warn("\u6279\u5904\u7406\u8017\u65f6:{}ms,\u5171{}\u6761\u8bb0\u5f55", (Object)time, (Object)i);
                }
            }
            if (i < this.maxElements) {
                try {
                    for (int j = 0; j < i; ++j) {
                        array[j] = null;
                    }
                    Thread.sleep(this.maxWait);
                }
                catch (InterruptedException j) {}
                continue;
            }
            if (!master || logtime >= starttime) continue;
            logtime = starttime + 5000L;
            int size = this.queue.size();
            if (size <= this.warningLines) continue;
            log.warn("\u6279\u5904\u7406\u961f\u5217\u7e41\u5fd9, size:{}", (Object)size);
        }
    }
}

