/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.core.handler;

import io.github.yezhihao.netmc.core.model.Header;
import io.github.yezhihao.netmc.core.model.Message;
import io.github.yezhihao.netmc.session.Session;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public abstract class Handler {
    public static final int MESSAGE = 0;
    public static final int SESSION = 1;
    public static final int HEADER = 2;
    public final Object targetObject;
    public final Method targetMethod;
    public final int[] parameterTypes;
    public final boolean returnVoid;
    public final String desc;

    public Handler(Object targetObject, Method targetMethod, String desc) {
        this.targetObject = targetObject;
        this.targetMethod = targetMethod;
        this.returnVoid = targetMethod.getReturnType().isAssignableFrom(Void.TYPE);
        this.desc = desc;
        Type[] types = targetMethod.getGenericParameterTypes();
        int[] parameterTypes = new int[types.length];
        try {
            for (int i = 0; i < types.length; ++i) {
                Type type = types[i];
                Class clazz = type instanceof ParameterizedTypeImpl ? (Class)((ParameterizedTypeImpl)type).getActualTypeArguments()[0] : (Class)type;
                if (Message.class.isAssignableFrom(clazz)) {
                    parameterTypes[i] = 0;
                    continue;
                }
                if (Header.class.isAssignableFrom(clazz)) {
                    parameterTypes[i] = 2;
                    continue;
                }
                if (!Session.class.isAssignableFrom(clazz)) continue;
                parameterTypes[i] = 1;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.parameterTypes = parameterTypes;
    }

    public <T extends Message> T invoke(T request, Session session) throws Exception {
        Object[] args = new Object[this.parameterTypes.length];
        block5: for (int i = 0; i < this.parameterTypes.length; ++i) {
            int type = this.parameterTypes[i];
            switch (type) {
                case 0: {
                    args[i] = request;
                    continue block5;
                }
                case 1: {
                    args[i] = session;
                    continue block5;
                }
                case 2: {
                    args[i] = request.getHeader();
                }
            }
        }
        return (T)((Message)this.targetMethod.invoke(this.targetObject, args));
    }

    public String toString() {
        return this.desc;
    }
}

