/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.session;

import io.github.yezhihao.netmc.core.model.Header;
import io.github.yezhihao.netmc.core.model.Message;
import io.github.yezhihao.netmc.core.model.Response;
import io.github.yezhihao.netmc.session.Session;
import io.github.yezhihao.netmc.session.SessionManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageManager {
    private static final Logger log = LoggerFactory.getLogger((String)MessageManager.class.getSimpleName());
    private Map<String, SynchronousQueue> topicSubscribers = new ConcurrentHashMap<String, SynchronousQueue>();
    private SessionManager sessionManager;

    public MessageManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public boolean notify(Message<? extends Header> message) {
        Header header = message.getHeader();
        Object clientId = header.getClientId();
        Session session = this.sessionManager.get(clientId);
        if (session == null) {
            log.info("<<<<<<<<<<\u6d88\u606f\u53d1\u9001\u5931\u8d25,\u672a\u6ce8\u518c,{}", message);
            return false;
        }
        header.setSerialNo(session.nextSerialNo());
        session.writeObject(message);
        return true;
    }

    public <T> T request(Message<? extends Header> request, Class<T> responseClass) {
        return this.request(request, responseClass, 20000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T request(Message<? extends Header> request, Class<T> responseClass, long timeout) {
        Header header = request.getHeader();
        Object clientId = header.getClientId();
        Session session = this.sessionManager.get(clientId);
        if (session == null) {
            log.info("<<<<<<<<<<\u6d88\u606f\u53d1\u9001\u5931\u8d25,\u672a\u6ce8\u518c,{}", request);
            return null;
        }
        header.setSerialNo(session.nextSerialNo());
        String key = MessageManager.requestKey(header, responseClass);
        SynchronousQueue syncQueue = this.subscribe(key);
        if (syncQueue == null) {
            log.info("<<<<<<<<<<\u8bf7\u52ff\u91cd\u590d\u53d1\u9001,{}", request);
        }
        try {
            session.writeObject(request);
            Object e = syncQueue.poll(timeout, TimeUnit.MILLISECONDS);
            return (T)e;
        }
        catch (InterruptedException e) {
            log.warn("<<<<<<<<<<\u7b49\u5f85\u54cd\u5e94\u8d85\u65f6" + session, (Throwable)e);
        }
        finally {
            this.unsubscribe(key);
        }
        return null;
    }

    public boolean response(Message message) {
        SynchronousQueue queue = this.topicSubscribers.get(MessageManager.responseKey(message));
        if (queue != null) {
            return queue.offer(message);
        }
        return false;
    }

    private SynchronousQueue subscribe(String key) {
        SynchronousQueue queue = null;
        if (!this.topicSubscribers.containsKey(key)) {
            queue = new SynchronousQueue();
            this.topicSubscribers.put(key, queue);
        }
        return queue;
    }

    private void unsubscribe(String key) {
        this.topicSubscribers.remove(key);
    }

    private static String requestKey(Header header, Class responseClass) {
        StringBuilder key = new StringBuilder(47);
        key.append(header.getClientId()).append('/').append(responseClass.getName());
        if (Response.class.isAssignableFrom(responseClass)) {
            key.append('/').append(header.getSerialNo());
        }
        return key.toString();
    }

    private static String responseKey(Message response) {
        Class<?> responseClass = response.getClass();
        Object header = response.getHeader();
        StringBuilder key = new StringBuilder(47);
        key.append(header.getClientId()).append('/').append(responseClass.getName());
        if (response instanceof Response) {
            key.append('/').append(((Response)((Object)response)).getSerialNo());
        }
        return key.toString();
    }
}

