/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.session;

import io.github.yezhihao.netmc.core.model.Header;
import io.github.yezhihao.netmc.session.SessionManager;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger log = LoggerFactory.getLogger((String)Session.class.getSimpleName());
    public static final AttributeKey<Session> KEY = AttributeKey.newInstance((String)Session.class.getName());
    protected final Channel channel;
    private AtomicInteger serialNo = new AtomicInteger(0);
    private boolean registered = false;
    private Object clientId;
    private final long creationTime;
    private volatile long lastAccessedTime;
    private Map<String, Object> attributes;
    private Object subject;
    private Object snapshot;
    private Integer protocolVersion;
    private SessionManager sessionManager;

    protected Session(Channel channel, SessionManager sessionManager) {
        this.channel = channel;
        this.sessionManager = sessionManager;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.attributes = new TreeMap<String, Object>();
    }

    public void writeObject(Object message) {
        log.info("<<<<<<<<<<\u6d88\u606f\u4e0b\u53d1{},{}", (Object)this, message);
        this.channel.writeAndFlush(message);
    }

    public int getId() {
        return this.channel.id().hashCode();
    }

    public int nextSerialNo() {
        int next;
        int current;
        while (!this.serialNo.compareAndSet(current, (next = (current = this.serialNo.get()) > 65535 ? 0 : current) + 1)) {
        }
        return next;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void register(Header header) {
        this.register(header, null);
    }

    public void register(Header header, Object subject) {
        this.clientId = header.getClientId();
        this.registered = true;
        this.subject = subject;
        this.sessionManager.put(this.clientId, this);
    }

    public void register(Object clientId) {
        this.register(clientId, null);
    }

    public void register(Object clientId, Object subject) {
        this.clientId = clientId;
        this.registered = true;
        this.subject = subject;
        this.sessionManager.put(clientId, this);
    }

    public Object getClientId() {
        return this.clientId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public long access() {
        this.lastAccessedTime = System.currentTimeMillis();
        return this.lastAccessedTime;
    }

    public Collection<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public Object getSubject() {
        return this.subject;
    }

    public void setSubject(Object subject) {
        this.subject = subject;
    }

    public Object getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Object snapshot) {
        this.snapshot = snapshot;
    }

    public Integer getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public Integer cachedProtocolVersion(Object clientId) {
        return this.sessionManager.getVersion(clientId);
    }

    public void recordProtocolVersion(Object clientId, int protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.sessionManager.putVersion(clientId, protocolVersion);
    }

    public void invalidate() {
        this.channel.close();
        this.sessionManager.callSessionDestroyedListener(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session that = (Session)o;
        return this.getId() == that.getId();
    }

    public int hashCode() {
        return this.getId();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(66);
        sb.append("[ip=").append(this.channel.remoteAddress());
        sb.append(", cid=").append(this.clientId);
        sb.append(", reg=").append(this.registered);
        sb.append(']');
        return sb.toString();
    }
}

