/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.session;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.github.yezhihao.netmc.session.Session;
import io.github.yezhihao.netmc.session.SessionListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class SessionManager {
    private Map<Object, Session> sessionMap = new ConcurrentHashMap<Object, Session>();
    private Cache<Object, Integer> versionCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private ChannelFutureListener remover = future -> {
        Session session = (Session)future.channel().attr(Session.KEY).get();
        if (session != null) {
            this.sessionMap.remove(session.getClientId(), session);
        }
    };
    private SessionListener sessionListener;

    public SessionManager() {
    }

    public SessionManager(SessionListener sessionListener) {
        this();
        this.sessionListener = sessionListener;
    }

    public Session newSession(Channel channel) {
        Session session = new Session(channel, this);
        this.callSessionCreatedListener(session);
        return session;
    }

    protected void callSessionDestroyedListener(Session session) {
        if (this.sessionListener != null) {
            this.sessionListener.sessionDestroyed(session);
        }
    }

    protected void callSessionCreatedListener(Session session) {
        if (this.sessionListener != null) {
            this.sessionListener.sessionCreated(session);
        }
    }

    public Session get(Object clientId) {
        return this.sessionMap.get(clientId);
    }

    public Collection<Session> all() {
        return this.sessionMap.values();
    }

    protected void put(Object clientId, Session newSession) {
        Session oldSession = this.sessionMap.put(clientId, newSession);
        if (!newSession.equals(oldSession)) {
            newSession.channel.closeFuture().addListener((GenericFutureListener)this.remover);
        }
    }

    public void putVersion(Object clientId, int version) {
        this.versionCache.put(clientId, (Object)version);
    }

    public Integer getVersion(Object clientId) {
        return (Integer)this.versionCache.getIfPresent(clientId);
    }
}

