/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger((String)ClassUtils.class.getSimpleName());

    public static List<Class<?>> getClassList(String packageName, Class<? extends Annotation> annotationClass) {
        List<Class<?>> classList = ClassUtils.getClassList(packageName);
        Iterator<Class<?>> iterator = classList.iterator();
        while (iterator.hasNext()) {
            Class<?> next = iterator.next();
            if (next.isAnnotationPresent(annotationClass)) continue;
            iterator.remove();
        }
        return classList;
    }

    public static List<Class<?>> getClassList(String packageName) {
        LinkedList classList = new LinkedList();
        String path = packageName.replace(".", "/");
        try {
            Enumeration<URL> urls = ClassUtils.getClassLoader().getResources(path);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if (protocol.equals("file")) {
                    ClassUtils.addClass(classList, url.toURI().getPath(), packageName);
                    continue;
                }
                if (!protocol.equals("jar")) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String entryName = jarEntry.getName();
                    if (!entryName.startsWith(path) || !entryName.endsWith(".class")) continue;
                    String className = entryName.substring(0, entryName.lastIndexOf(".")).replaceAll("/", ".");
                    ClassUtils.addClass(classList, className);
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7c7b\u51fa\u9519\uff01", (Throwable)e);
        }
        return classList;
    }

    private static void addClass(List<Class<?>> classList, String packagePath, String packageName) {
        try {
            File[] files = new File(packagePath).listFiles(file -> file.isDirectory() || file.getName().endsWith(".class"));
            if (files != null) {
                for (File file2 : files) {
                    String fileName = file2.getName();
                    if (file2.isFile()) {
                        String className = fileName.substring(0, fileName.lastIndexOf("."));
                        if (packageName != null) {
                            className = packageName + "." + className;
                        }
                        ClassUtils.addClass(classList, className);
                        continue;
                    }
                    String subPackagePath = fileName;
                    if (packageName != null) {
                        subPackagePath = packagePath + "/" + subPackagePath;
                    }
                    String subPackageName = fileName;
                    if (packageName != null) {
                        subPackageName = packageName + "." + subPackageName;
                    }
                    ClassUtils.addClass(classList, subPackagePath, subPackageName);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addClass(List<Class<?>> classList, String className) {
        classList.add(ClassUtils.loadClass(className, false));
    }

    public static Class<?> loadClass(String className, boolean isInitialized) {
        try {
            return Class.forName(className, isInitialized, ClassUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

