/*
 * Decompiled with CFR 0.152.
 */
package io.github.yezhihao.netmc.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class VirtualList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable {
    private final E[] elementData;
    private final int size;

    public VirtualList(E[] array, int length) {
        this.elementData = array;
        this.size = length;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.elementData.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public E get(int index) {
        return this.elementData[index];
    }

    @Override
    public E set(int index, E element) {
        E oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public int indexOf(Object o) {
        E[] a = this.elementData;
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (a[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elementData, 0, this.size, 16);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.size; ++i) {
            action.accept(this.elementData[i]);
        }
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        Objects.requireNonNull(operator);
        E[] a = this.elementData;
        for (int i = 0; i < this.size; ++i) {
            a[i] = operator.apply(a[i]);
        }
    }

    @Override
    public void sort(Comparator<? super E> c) {
        Arrays.sort(this.elementData, 0, this.size, c);
    }
}

