/*
 * Decompiled with CFR 0.152.
 */
package io.minio.policy;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.minio.policy.ConditionKeyMap;
import io.minio.policy.ConditionMap;
import io.minio.policy.Constants;
import io.minio.policy.PolicyType;
import io.minio.policy.Principal;
import io.minio.policy.Resources;
import io.minio.policy.Statement;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class BucketPolicy {
    @JsonIgnore
    private String bucketName;
    @JsonProperty(value="Version")
    private String version;
    @JsonProperty(value="Statement")
    private List<Statement> statements;
    @JsonIgnore
    private static final ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public BucketPolicy() {
    }

    public BucketPolicy(String bucketName) {
        this.bucketName = bucketName;
        this.version = "2012-10-17";
    }

    public List<Statement> statements() {
        return this.statements;
    }

    public static BucketPolicy parseJson(Reader reader, String bucketName) throws IOException {
        BucketPolicy bucketPolicy = (BucketPolicy)objectMapper.readValue(reader, BucketPolicy.class);
        bucketPolicy.bucketName = bucketName;
        return bucketPolicy;
    }

    @JsonIgnore
    public String getJson() throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)this);
    }

    private List<Statement> newBucketStatement(PolicyType policy, String prefix) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        if (policy == PolicyType.NONE || this.bucketName == null || this.bucketName.isEmpty()) {
            return statements;
        }
        Resources resources = new Resources("arn:aws:s3:::" + this.bucketName);
        Statement statement = new Statement();
        statement.setActions(Constants.COMMON_BUCKET_ACTIONS);
        statement.setEffect("Allow");
        statement.setPrincipal(new Principal("*"));
        statement.setResources(resources);
        statement.setSid("");
        statements.add(statement);
        if (policy == PolicyType.READ_ONLY || policy == PolicyType.READ_WRITE) {
            statement = new Statement();
            statement.setActions(Constants.READ_ONLY_BUCKET_ACTIONS);
            statement.setEffect("Allow");
            statement.setPrincipal(new Principal("*"));
            statement.setResources(resources);
            statement.setSid("");
            if (prefix != null && !prefix.isEmpty()) {
                statement.setConditions(new ConditionMap("StringEquals", new ConditionKeyMap("s3:prefix", prefix)));
            }
            statements.add(statement);
        }
        if (policy == PolicyType.WRITE_ONLY || policy == PolicyType.READ_WRITE) {
            statement = new Statement();
            statement.setActions(Constants.WRITE_ONLY_BUCKET_ACTIONS);
            statement.setEffect("Allow");
            statement.setPrincipal(new Principal("*"));
            statement.setResources(resources);
            statement.setSid("");
            statements.add(statement);
        }
        return statements;
    }

    private List<Statement> newObjectStatement(PolicyType policy, String prefix) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        if (policy == PolicyType.NONE || this.bucketName == null || this.bucketName.isEmpty()) {
            return statements;
        }
        Resources resources = new Resources("arn:aws:s3:::" + this.bucketName + "/" + prefix + "*");
        Statement statement = new Statement();
        statement.setEffect("Allow");
        statement.setPrincipal(new Principal("*"));
        statement.setResources(resources);
        statement.setSid("");
        if (policy == PolicyType.READ_ONLY) {
            statement.setActions(Constants.READ_ONLY_OBJECT_ACTIONS);
        } else if (policy == PolicyType.WRITE_ONLY) {
            statement.setActions(Constants.WRITE_ONLY_OBJECT_ACTIONS);
        } else if (policy == PolicyType.READ_WRITE) {
            statement.setActions(Constants.READ_WRITE_OBJECT_ACTIONS);
        }
        statements.add(statement);
        return statements;
    }

    private List<Statement> newStatements(PolicyType policy, String prefix) {
        List<Statement> statements = this.newBucketStatement(policy, prefix);
        List<Statement> objectStatements = this.newObjectStatement(policy, prefix);
        statements.addAll(objectStatements);
        return statements;
    }

    @JsonIgnore
    private boolean[] getInUsePolicy(String prefix) {
        String resourcePrefix = "arn:aws:s3:::" + this.bucketName + "/";
        String objectResource = "arn:aws:s3:::" + this.bucketName + "/" + prefix + "*";
        boolean readOnlyInUse = false;
        boolean writeOnlyInUse = false;
        for (Statement statement : this.statements) {
            if (!statement.resources().contains(objectResource) && !statement.resources().startsWith(resourcePrefix).isEmpty()) {
                if (statement.actions().containsAll(Constants.READ_ONLY_OBJECT_ACTIONS)) {
                    readOnlyInUse = true;
                }
                if (statement.actions().containsAll(Constants.WRITE_ONLY_OBJECT_ACTIONS)) {
                    writeOnlyInUse = true;
                }
            }
            if (!readOnlyInUse || !writeOnlyInUse) continue;
            break;
        }
        boolean[] rv = new boolean[]{readOnlyInUse, writeOnlyInUse};
        return rv;
    }

    private void removeStatements(String prefix) {
        String bucketResource = "arn:aws:s3:::" + this.bucketName;
        String objectResource = "arn:aws:s3:::" + this.bucketName + "/" + prefix + "*";
        boolean[] inUse = this.getInUsePolicy(prefix);
        boolean readOnlyInUse = inUse[0];
        boolean writeOnlyInUse = inUse[1];
        ArrayList<Statement> out = new ArrayList<Statement>();
        HashSet<String> s3PrefixValues = new HashSet<String>();
        ArrayList<Statement> readOnlyBucketStatements = new ArrayList<Statement>();
        for (Statement statement : this.statements) {
            if (!statement.isValid(this.bucketName)) {
                out.add(statement);
                continue;
            }
            if (statement.resources().contains(bucketResource)) {
                if (statement.conditions() != null) {
                    statement.removeBucketActions(prefix, bucketResource, false, false);
                } else {
                    statement.removeBucketActions(prefix, bucketResource, readOnlyInUse, writeOnlyInUse);
                }
            } else if (statement.resources().contains(objectResource)) {
                statement.removeObjectActions(objectResource);
            }
            if (statement.actions().isEmpty()) continue;
            if (statement.resources().contains(bucketResource) && statement.actions().containsAll(Constants.READ_ONLY_BUCKET_ACTIONS) && statement.effect().equals("Allow") && statement.principal().aws().contains("*")) {
                if (statement.conditions() != null) {
                    Set values;
                    ConditionKeyMap stringEqualsValue = (ConditionKeyMap)statement.conditions().get("StringEquals");
                    if (stringEqualsValue != null && (values = (Set)stringEqualsValue.get("s3:prefix")) != null) {
                        for (String v : values) {
                            s3PrefixValues.add(bucketResource + "/" + v + "*");
                        }
                    }
                } else if (!s3PrefixValues.isEmpty()) {
                    readOnlyBucketStatements.add(statement);
                    continue;
                }
            }
            out.add(statement);
        }
        boolean skipBucketStatement = true;
        String resourcePrefix = "arn:aws:s3:::" + this.bucketName + "/";
        for (Statement statement : out) {
            HashSet intersection = new HashSet(s3PrefixValues);
            intersection.retainAll(statement.resources());
            if (statement.resources().startsWith(resourcePrefix).isEmpty() || !intersection.isEmpty()) continue;
            skipBucketStatement = false;
            break;
        }
        for (Statement statement : readOnlyBucketStatements) {
            Set<String> aws = statement.principal().aws();
            if (skipBucketStatement && statement.resources().contains(bucketResource) && statement.effect().equals("Allow") && aws != null && aws.contains("*") && statement.conditions() == null) continue;
            out.add(statement);
        }
        if (out.size() == 1) {
            Statement statement = (Statement)out.get(0);
            Set<String> aws = statement.principal().aws();
            if (statement.resources().contains(bucketResource) && statement.actions().containsAll(Constants.COMMON_BUCKET_ACTIONS) && statement.effect().equals("Allow") && aws != null && aws.contains("*") && statement.conditions() == null) {
                out = new ArrayList();
            }
        }
        this.statements = out;
    }

    private void appendStatement(Statement statement) {
        for (Statement s : this.statements) {
            Set<String> aws = s.principal().aws();
            ConditionMap conditions = s.conditions();
            if (s.actions().containsAll(statement.actions()) && s.effect().equals(statement.effect()) && aws != null && aws.containsAll(statement.principal().aws()) && conditions != null && conditions.equals(statement.conditions())) {
                s.resources().addAll(statement.resources());
                return;
            }
            if (s.resources().containsAll(statement.resources()) && s.effect().equals(statement.effect()) && aws != null && aws.containsAll(statement.principal().aws()) && conditions != null && conditions.equals(statement.conditions())) {
                s.actions().addAll(statement.actions());
                return;
            }
            if (!s.resources().containsAll(statement.resources()) || !s.actions().containsAll(statement.actions()) || !s.effect().equals(statement.effect()) || aws == null || !aws.containsAll(statement.principal().aws())) continue;
            if (conditions != null && conditions.equals(statement.conditions())) {
                return;
            }
            if (conditions == null || statement.conditions() == null) continue;
            conditions.putAll(statement.conditions());
            return;
        }
        if (!statement.actions().isEmpty() || !statement.resources().isEmpty()) {
            this.statements.add(statement);
        }
    }

    private void appendStatements(PolicyType policy, String prefix) {
        List<Statement> appendStatements = this.newStatements(policy, prefix);
        for (Statement statement : appendStatements) {
            this.appendStatement(statement);
        }
    }

    @JsonIgnore
    public PolicyType getPolicy(String prefix) {
        String bucketResource = "arn:aws:s3:::" + this.bucketName;
        String objectResource = "arn:aws:s3:::" + this.bucketName + "/" + prefix + "*";
        boolean bucketCommonFound = false;
        boolean bucketReadOnly = false;
        boolean bucketWriteOnly = false;
        String matchedResource = "";
        boolean objReadOnly = false;
        boolean objWriteOnly = false;
        if (this.statements == null) {
            return PolicyType.NONE;
        }
        for (Statement s : this.statements) {
            boolean[] rv;
            Set<Object> matchedObjResources = new HashSet<String>();
            if (s.resources().contains(objectResource)) {
                matchedObjResources.add(objectResource);
            } else {
                matchedObjResources = s.resources().match(objectResource);
            }
            if (!matchedObjResources.isEmpty()) {
                rv = s.getObjectPolicy();
                boolean readOnly = rv[0];
                boolean writeOnly = rv[1];
                for (String string : matchedObjResources) {
                    if (matchedResource.length() < string.length()) {
                        objReadOnly = readOnly;
                        objWriteOnly = writeOnly;
                        matchedResource = string;
                        continue;
                    }
                    if (matchedResource.length() != string.length()) continue;
                    objReadOnly = objReadOnly || readOnly;
                    objWriteOnly = objWriteOnly || writeOnly;
                    matchedResource = string;
                }
                continue;
            }
            if (!s.resources().contains(bucketResource)) continue;
            rv = s.getBucketPolicy(prefix);
            boolean commonFound = rv[0];
            boolean readOnly = rv[1];
            boolean writeOnly = rv[2];
            bucketCommonFound = bucketCommonFound || commonFound;
            bucketReadOnly = bucketReadOnly || readOnly;
            bucketWriteOnly = bucketWriteOnly || writeOnly;
        }
        if (bucketCommonFound) {
            if (bucketReadOnly && bucketWriteOnly && objReadOnly && objWriteOnly) {
                return PolicyType.READ_WRITE;
            }
            if (bucketReadOnly && objReadOnly) {
                return PolicyType.READ_ONLY;
            }
            if (bucketWriteOnly && objWriteOnly) {
                return PolicyType.WRITE_ONLY;
            }
        }
        return PolicyType.NONE;
    }

    @JsonIgnore
    public Map<String, PolicyType> getPolicies() {
        Hashtable<String, PolicyType> policyRules = new Hashtable<String, PolicyType>();
        HashSet<String> objResources = new HashSet<String>();
        String bucketResource = "arn:aws:s3:::" + this.bucketName;
        for (Statement s : this.statements) {
            objResources.addAll(s.resources().startsWith(bucketResource + "/"));
        }
        for (String r : objResources) {
            String asterisk = "";
            if (r.endsWith("*")) {
                r = r.substring(0, r.length() - 1);
                asterisk = "*";
            }
            String objectPath = r.substring(bucketResource.length() + 1, r.length());
            PolicyType policy = this.getPolicy(objectPath);
            policyRules.put(this.bucketName + "/" + objectPath + asterisk, policy);
        }
        return policyRules;
    }

    @JsonIgnore
    public void setPolicy(PolicyType policy, String prefix) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.removeStatements(prefix);
        this.appendStatements(policy, prefix);
    }
}

