/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.api.yaml;

import io.shardingsphere.core.api.ShardingDataSourceFactory;
import io.shardingsphere.core.yaml.sharding.YamlShardingConfiguration;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public final class YamlShardingDataSourceFactory {
    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlShardingConfiguration config = YamlShardingConfiguration.unmarshal((File)yamlFile);
        return ShardingDataSourceFactory.createDataSource(config.getDataSources(), config.getShardingRule().getShardingRuleConfiguration(), config.getShardingRule().getConfigMap(), config.getShardingRule().getProps());
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlShardingConfiguration config = YamlShardingConfiguration.unmarshal((byte[])yamlBytes);
        return ShardingDataSourceFactory.createDataSource(config.getDataSources(), config.getShardingRule().getShardingRuleConfiguration(), config.getShardingRule().getConfigMap(), config.getShardingRule().getProps());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        YamlShardingConfiguration config = YamlShardingConfiguration.unmarshal((File)yamlFile);
        return ShardingDataSourceFactory.createDataSource(dataSourceMap, config.getShardingRule().getShardingRuleConfiguration(), config.getShardingRule().getConfigMap(), config.getShardingRule().getProps());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        YamlShardingConfiguration config = YamlShardingConfiguration.unmarshal((byte[])yamlBytes);
        return ShardingDataSourceFactory.createDataSource(dataSourceMap, config.getShardingRule().getShardingRuleConfiguration(), config.getShardingRule().getConfigMap(), config.getShardingRule().getProps());
    }

    private YamlShardingDataSourceFactory() {
    }
}

