/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.type.batch;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.BaseStatementUnit;
import io.shardingsphere.core.executor.ExecuteCallback;
import io.shardingsphere.core.executor.ExecutorEngine;
import io.shardingsphere.core.executor.type.batch.BatchPreparedStatementUnit;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class BatchPreparedStatementExecutor {
    private final ExecutorEngine executorEngine;
    private final DatabaseType dbType;
    private final SQLType sqlType;
    private final Collection<BatchPreparedStatementUnit> batchPreparedStatementUnits;
    private final int batchCount;

    public int[] executeBatch() throws SQLException {
        return this.accumulate(this.executorEngine.execute(this.sqlType, this.batchPreparedStatementUnits, new ExecuteCallback<int[]>(){

            @Override
            public int[] execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return baseStatementUnit.getStatement().executeBatch();
            }
        }));
    }

    private int[] accumulate(List<int[]> results) {
        int[] result = new int[this.batchCount];
        int count = 0;
        for (BatchPreparedStatementUnit each : this.batchPreparedStatementUnits) {
            for (Map.Entry<Integer, Integer> entry : each.getJdbcAndActualAddBatchCallTimesMap().entrySet()) {
                int value;
                int n = value = null == results.get(count) ? 0 : results.get(count)[entry.getValue()];
                if (DatabaseType.Oracle == this.dbType) {
                    result[entry.getKey().intValue()] = value;
                    continue;
                }
                int n2 = entry.getKey();
                result[n2] = result[n2] + value;
            }
            ++count;
        }
        return result;
    }

    @ConstructorProperties(value={"executorEngine", "dbType", "sqlType", "batchPreparedStatementUnits", "batchCount"})
    public BatchPreparedStatementExecutor(ExecutorEngine executorEngine, DatabaseType dbType, SQLType sqlType, Collection<BatchPreparedStatementUnit> batchPreparedStatementUnits, int batchCount) {
        this.executorEngine = executorEngine;
        this.dbType = dbType;
        this.sqlType = sqlType;
        this.batchPreparedStatementUnits = batchPreparedStatementUnits;
        this.batchCount = batchCount;
    }
}

