/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collection;
import java.util.Collections;
import net.lightbody.bmp.filters.HttpsAwareFiltersAdapter;
import net.lightbody.bmp.proxy.BlacklistEntry;

public class BlacklistFilter
extends HttpsAwareFiltersAdapter {
    private final Collection<BlacklistEntry> blacklistedUrls;

    public BlacklistFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, Collection<BlacklistEntry> blacklistedUrls) {
        super(originalRequest, ctx);
        this.blacklistedUrls = blacklistedUrls != null ? blacklistedUrls : Collections.emptyList();
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            String url = this.getFullUrl(httpRequest);
            for (BlacklistEntry entry : this.blacklistedUrls) {
                if (HttpMethod.CONNECT.equals((Object)httpRequest.getMethod()) && entry.getHttpMethodPatern() == null || !entry.matches(url, httpRequest.getMethod().name())) continue;
                HttpResponseStatus status = HttpResponseStatus.valueOf((int)entry.getStatusCode());
                DefaultFullHttpResponse resp = new DefaultFullHttpResponse(httpRequest.getProtocolVersion(), status);
                HttpHeaders.setContentLength((HttpMessage)resp, (long)0L);
                return resp;
            }
        }
        return null;
    }
}

