/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerResponseCaptureFilter
extends HttpFiltersAdapter {
    private static final Logger log = LoggerFactory.getLogger(ServerResponseCaptureFilter.class);
    private volatile HttpResponse httpResponse;
    private final ByteArrayOutputStream rawResponseContents = new ByteArrayOutputStream();
    private volatile byte[] fullResponseContents;
    private volatile HttpHeaders trailingHeaders;
    private volatile boolean responseCompressed;
    private volatile boolean decompressionSuccessful;
    private volatile String contentEncoding;
    private final boolean decompressEncodedContent;

    public ServerResponseCaptureFilter(HttpRequest originalRequest, boolean decompressEncodedContent) {
        super(originalRequest);
        this.decompressEncodedContent = decompressEncodedContent;
    }

    public ServerResponseCaptureFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, boolean decompressEncodedContent) {
        super(originalRequest, ctx);
        this.decompressEncodedContent = decompressEncodedContent;
    }

    public HttpObject serverToProxyResponse(HttpObject httpObject) {
        if (httpObject instanceof HttpResponse) {
            this.httpResponse = (HttpResponse)httpObject;
        }
        if (httpObject instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)httpObject;
            this.storeResponseContent(httpContent);
            if (httpContent instanceof LastHttpContent) {
                LastHttpContent lastContent = (LastHttpContent)httpContent;
                this.captureTrailingHeaders(lastContent);
                this.captureContentEncoding();
                this.captureFullResponseContents();
            }
        }
        return super.serverToProxyResponse(httpObject);
    }

    protected void captureFullResponseContents() {
        this.fullResponseContents = this.getRawResponseContents();
        if (this.contentEncoding != null) {
            this.responseCompressed = true;
            if (this.decompressEncodedContent) {
                this.decompressContents();
            }
        } else {
            this.responseCompressed = false;
        }
    }

    protected void decompressContents() {
        if (this.contentEncoding.equals("gzip")) {
            try {
                this.fullResponseContents = BrowserMobHttpUtil.decompressContents((byte[])this.getRawResponseContents());
                this.decompressionSuccessful = true;
            }
            catch (RuntimeException e) {
                log.warn("Failed to decompress response with encoding type " + this.contentEncoding + " when decoding request from " + this.originalRequest.getUri(), (Throwable)e);
            }
        } else {
            log.warn("Cannot decode unsupported content encoding type {}", (Object)this.contentEncoding);
        }
    }

    protected void captureContentEncoding() {
        this.contentEncoding = HttpHeaders.getHeader((HttpMessage)this.httpResponse, (String)"Content-Encoding");
    }

    protected void captureTrailingHeaders(LastHttpContent lastContent) {
        this.trailingHeaders = lastContent.trailingHeaders();
    }

    protected void storeResponseContent(HttpContent httpContent) {
        ByteBuf bufferedContent = httpContent.content();
        byte[] content = BrowserMobHttpUtil.extractReadableBytes((ByteBuf)bufferedContent);
        try {
            this.rawResponseContents.write(content);
        }
        catch (IOException iOException) {}
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public byte[] getFullResponseContents() {
        return this.fullResponseContents;
    }

    public byte[] getRawResponseContents() {
        return this.rawResponseContents.toByteArray();
    }

    public HttpHeaders getTrailingHeaders() {
        return this.trailingHeaders;
    }

    public boolean isResponseCompressed() {
        return this.responseCompressed;
    }

    public boolean isDecompressionSuccessful() {
        if (!this.decompressEncodedContent) {
            return false;
        }
        return this.decompressionSuccessful;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }
}

