/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.headers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderSignature;
import net.lingala.zip4j.io.outputstream.CountingOutputStream;
import net.lingala.zip4j.io.outputstream.SplitOutputStream;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.ExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryLocator;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.RawIO;
import net.lingala.zip4j.util.Zip4jUtil;

public class HeaderWriter {
    private static final short ZIP64_EXTRA_DATA_RECORD_SIZE_LFH = 16;
    private static final short ZIP64_EXTRA_DATA_RECORD_SIZE_FH = 28;
    private static final short AES_EXTRA_DATA_RECORD_SIZE = 11;
    private RawIO rawIO = new RawIO();
    private byte[] longBuff = new byte[8];

    public void writeLocalFileHeader(ZipModel zipModel, LocalFileHeader localFileHeader, OutputStream outputStream, Charset charset) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            boolean writeZip64Header;
            this.rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)localFileHeader.getSignature().getValue());
            this.rawIO.writeShortLittleEndian(byteArrayOutputStream, localFileHeader.getVersionNeededToExtract());
            byteArrayOutputStream.write(localFileHeader.getGeneralPurposeFlag());
            this.rawIO.writeShortLittleEndian(byteArrayOutputStream, localFileHeader.getCompressionMethod().getCode());
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getLastModifiedTime());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getCrc());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            boolean bl = writeZip64Header = localFileHeader.getCompressedSize() >= 0xFFFFFFFFL || localFileHeader.getUncompressedSize() >= 0xFFFFFFFFL;
            if (writeZip64Header) {
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                zipModel.setZip64Format(true);
                localFileHeader.setWriteCompressedSizeInZip64ExtraRecord(true);
            } else {
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getCompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getUncompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                localFileHeader.setWriteCompressedSizeInZip64ExtraRecord(false);
            }
            byte[] fileNameBytes = new byte[]{};
            if (Zip4jUtil.isStringNotNullAndNotEmpty(localFileHeader.getFileName())) {
                fileNameBytes = localFileHeader.getFileName().getBytes(charset);
            }
            this.rawIO.writeShortLittleEndian(byteArrayOutputStream, fileNameBytes.length);
            int extraFieldLength = 0;
            if (writeZip64Header) {
                extraFieldLength += 20;
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                extraFieldLength += 11;
            }
            this.rawIO.writeShortLittleEndian(byteArrayOutputStream, extraFieldLength);
            if (fileNameBytes.length > 0) {
                byteArrayOutputStream.write(fileNameBytes);
            }
            if (writeZip64Header) {
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue());
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, 16);
                this.rawIO.writeLongLittleEndian(byteArrayOutputStream, localFileHeader.getUncompressedSize());
                this.rawIO.writeLongLittleEndian(byteArrayOutputStream, localFileHeader.getCompressedSize());
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                AESExtraDataRecord aesExtraDataRecord = localFileHeader.getAesExtraDataRecord();
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)aesExtraDataRecord.getSignature().getValue());
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, aesExtraDataRecord.getDataSize());
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, aesExtraDataRecord.getAesVersion().getVersionNumber());
                byteArrayOutputStream.write(aesExtraDataRecord.getVendorID().getBytes());
                byte[] aesStrengthBytes = new byte[]{(byte)aesExtraDataRecord.getAesKeyStrength().getRawCode()};
                byteArrayOutputStream.write(aesStrengthBytes);
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, aesExtraDataRecord.getCompressionMethod().getCode());
            }
            outputStream.write(byteArrayOutputStream.toByteArray());
        }
    }

    public void writeExtendedLocalHeader(LocalFileHeader localFileHeader, OutputStream outputStream) throws IOException {
        if (localFileHeader == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write extended local header");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)HeaderSignature.EXTRA_DATA_RECORD.getValue());
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getCrc());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            if (localFileHeader.isWriteCompressedSizeInZip64ExtraRecord()) {
                this.rawIO.writeLongLittleEndian(byteArrayOutputStream, localFileHeader.getCompressedSize());
                this.rawIO.writeLongLittleEndian(byteArrayOutputStream, localFileHeader.getUncompressedSize());
            } else {
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getCompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getUncompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
            }
            outputStream.write(byteArrayOutputStream.toByteArray());
        }
    }

    public void finalizeZipFile(ZipModel zipModel, OutputStream outputStream, Charset charset) throws IOException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.processHeaderData(zipModel, outputStream);
            long offsetCentralDir = zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
            this.writeCentralDirectory(zipModel, byteArrayOutputStream, this.rawIO, charset);
            int sizeOfCentralDir = byteArrayOutputStream.size();
            if (zipModel.isZip64Format() || offsetCentralDir >= 0xFFFFFFFFL || zipModel.getCentralDirectory().getFileHeaders().size() >= 65535) {
                if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
                    zipModel.setZip64EndOfCentralDirectoryRecord(new Zip64EndOfCentralDirectoryRecord());
                }
                if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
                    zipModel.setZip64EndOfCentralDirectoryLocator(new Zip64EndOfCentralDirectoryLocator());
                }
                zipModel.getZip64EndOfCentralDirectoryLocator().setOffsetZip64EndOfCentralDirectoryRecord(offsetCentralDir + (long)sizeOfCentralDir);
                if (this.isSplitZipFile(outputStream)) {
                    int currentSplitFileCounter = this.getCurrentSplitFileCounter(outputStream);
                    zipModel.getZip64EndOfCentralDirectoryLocator().setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(currentSplitFileCounter);
                    zipModel.getZip64EndOfCentralDirectoryLocator().setTotalNumberOfDiscs(currentSplitFileCounter + 1);
                } else {
                    zipModel.getZip64EndOfCentralDirectoryLocator().setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(0);
                    zipModel.getZip64EndOfCentralDirectoryLocator().setTotalNumberOfDiscs(1);
                }
                this.writeZip64EndOfCentralDirectoryRecord(zipModel, sizeOfCentralDir, offsetCentralDir, byteArrayOutputStream, this.rawIO);
                this.writeZip64EndOfCentralDirectoryLocator(zipModel, byteArrayOutputStream, this.rawIO);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, sizeOfCentralDir, offsetCentralDir, byteArrayOutputStream, this.rawIO, charset);
            this.writeZipHeaderBytes(zipModel, outputStream, byteArrayOutputStream.toByteArray(), charset);
        }
    }

    public void finalizeZipFileWithoutValidations(ZipModel zipModel, OutputStream outputStream, Charset charset) throws IOException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file without validations");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            long offsetCentralDir = zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
            this.writeCentralDirectory(zipModel, byteArrayOutputStream, this.rawIO, charset);
            int sizeOfCentralDir = byteArrayOutputStream.size();
            if (zipModel.isZip64Format() || offsetCentralDir >= 0xFFFFFFFFL || zipModel.getCentralDirectory().getFileHeaders().size() >= 65535) {
                if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
                    zipModel.setZip64EndOfCentralDirectoryRecord(new Zip64EndOfCentralDirectoryRecord());
                }
                if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
                    zipModel.setZip64EndOfCentralDirectoryLocator(new Zip64EndOfCentralDirectoryLocator());
                }
                zipModel.getZip64EndOfCentralDirectoryLocator().setOffsetZip64EndOfCentralDirectoryRecord(offsetCentralDir + (long)sizeOfCentralDir);
                this.writeZip64EndOfCentralDirectoryRecord(zipModel, sizeOfCentralDir, offsetCentralDir, byteArrayOutputStream, this.rawIO);
                this.writeZip64EndOfCentralDirectoryLocator(zipModel, byteArrayOutputStream, this.rawIO);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, sizeOfCentralDir, offsetCentralDir, byteArrayOutputStream, this.rawIO, charset);
            this.writeZipHeaderBytes(zipModel, outputStream, byteArrayOutputStream.toByteArray(), charset);
        }
    }

    public void updateLocalFileHeader(FileHeader fileHeader, ZipModel zipModel, SplitOutputStream outputStream) throws IOException {
        SplitOutputStream currOutputStream;
        if (fileHeader == null || zipModel == null) {
            throw new ZipException("invalid input parameters, cannot update local file header");
        }
        boolean closeFlag = false;
        if (fileHeader.getDiskNumberStart() != outputStream.getCurrentSplitFileCounter()) {
            String parentFile = zipModel.getZipFile().getParent();
            String fileNameWithoutExt = FileUtils.getZipFileNameWithoutExtension(zipModel.getZipFile().getName());
            String fileName = parentFile + System.getProperty("file.separator");
            fileName = fileHeader.getDiskNumberStart() < 9 ? fileName + fileNameWithoutExt + ".z0" + (fileHeader.getDiskNumberStart() + 1) : fileName + fileNameWithoutExt + ".z" + (fileHeader.getDiskNumberStart() + 1);
            currOutputStream = new SplitOutputStream(new File(fileName));
            closeFlag = true;
        } else {
            currOutputStream = outputStream;
        }
        long currOffset = currOutputStream.getFilePointer();
        currOutputStream.seek(fileHeader.getOffsetLocalHeader() + 14L);
        this.rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getCrc());
        currOutputStream.write(this.longBuff, 0, 4);
        this.updateFileSizesInLocalFileHeader(currOutputStream, fileHeader);
        if (closeFlag) {
            currOutputStream.close();
        } else {
            outputStream.seek(currOffset);
        }
    }

    private void updateFileSizesInLocalFileHeader(SplitOutputStream outputStream, FileHeader fileHeader) throws IOException {
        if (fileHeader.getUncompressedSize() >= 0xFFFFFFFFL) {
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
            outputStream.write(this.longBuff, 0, 4);
            outputStream.write(this.longBuff, 0, 4);
            int zip64CompressedSizeOffset = 4 + fileHeader.getFileNameLength() + 2 + 2;
            if (outputStream.skipBytes(zip64CompressedSizeOffset) != zip64CompressedSizeOffset) {
                throw new ZipException("Unable to skip " + zip64CompressedSizeOffset + " bytes to update LFH");
            }
            this.rawIO.writeLongLittleEndian(outputStream, fileHeader.getUncompressedSize());
            this.rawIO.writeLongLittleEndian(outputStream, fileHeader.getCompressedSize());
        } else {
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getCompressedSize());
            outputStream.write(this.longBuff, 0, 4);
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getUncompressedSize());
            outputStream.write(this.longBuff, 0, 4);
        }
    }

    private boolean isSplitZipFile(OutputStream outputStream) {
        if (outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)outputStream).isSplitZipFile();
        }
        if (outputStream instanceof CountingOutputStream) {
            return ((CountingOutputStream)outputStream).isSplitZipFile();
        }
        return false;
    }

    private int getCurrentSplitFileCounter(OutputStream outputStream) {
        if (outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)outputStream).getCurrentSplitFileCounter();
        }
        return ((CountingOutputStream)outputStream).getCurrentSplitFileCounter();
    }

    private void writeZipHeaderBytes(ZipModel zipModel, OutputStream outputStream, byte[] buff, Charset charset) throws IOException {
        if (buff == null) {
            throw new ZipException("invalid buff to write as zip headers");
        }
        if (outputStream instanceof CountingOutputStream && ((CountingOutputStream)outputStream).checkBuffSizeAndStartNextSplitFile(buff.length)) {
            this.finalizeZipFile(zipModel, outputStream, charset);
            return;
        }
        outputStream.write(buff);
    }

    private void processHeaderData(ZipModel zipModel, OutputStream outputStream) throws IOException {
        int currentSplitFileCounter = 0;
        if (outputStream instanceof CountingOutputStream) {
            zipModel.getEndOfCentralDirectoryRecord().setOffsetOfStartOfCentralDirectory(((CountingOutputStream)outputStream).getFilePointer());
            currentSplitFileCounter = ((CountingOutputStream)outputStream).getCurrentSplitFileCounter();
        }
        if (zipModel.isZip64Format()) {
            if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
                zipModel.setZip64EndOfCentralDirectoryRecord(new Zip64EndOfCentralDirectoryRecord());
            }
            if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
                zipModel.setZip64EndOfCentralDirectoryLocator(new Zip64EndOfCentralDirectoryLocator());
            }
            zipModel.getZip64EndOfCentralDirectoryLocator().setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(currentSplitFileCounter);
            zipModel.getZip64EndOfCentralDirectoryLocator().setTotalNumberOfDiscs(currentSplitFileCounter + 1);
        }
        zipModel.getEndOfCentralDirectoryRecord().setNumberOfThisDisk(currentSplitFileCounter);
        zipModel.getEndOfCentralDirectoryRecord().setNumberOfThisDiskStartOfCentralDir(currentSplitFileCounter);
    }

    private void writeCentralDirectory(ZipModel zipModel, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO, Charset charset) throws ZipException {
        if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null || zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return;
        }
        for (FileHeader fileHeader : zipModel.getCentralDirectory().getFileHeaders()) {
            this.writeFileHeader(zipModel, fileHeader, byteArrayOutputStream, rawIO, charset);
        }
    }

    private void writeFileHeader(ZipModel zipModel, FileHeader fileHeader, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO, Charset charset) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("input parameters is null, cannot write local file header");
        }
        try {
            byte[] emptyShortByte = new byte[]{0, 0};
            boolean writeZip64ExtendedInfo = false;
            if (this.isZip64Entry(fileHeader)) {
                writeZip64ExtendedInfo = true;
            }
            rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)fileHeader.getSignature().getValue());
            rawIO.writeShortLittleEndian(byteArrayOutputStream, fileHeader.getVersionMadeBy());
            rawIO.writeShortLittleEndian(byteArrayOutputStream, fileHeader.getVersionNeededToExtract());
            byteArrayOutputStream.write(fileHeader.getGeneralPurposeFlag());
            rawIO.writeShortLittleEndian(byteArrayOutputStream, fileHeader.getCompressionMethod().getCode());
            rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getLastModifiedTime());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getCrc());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            if (writeZip64ExtendedInfo) {
                rawIO.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                zipModel.setZip64Format(true);
            } else {
                rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getCompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getUncompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
            }
            byte[] fileNameBytes = new byte[]{};
            if (Zip4jUtil.isStringNotNullAndNotEmpty(fileHeader.getFileName())) {
                fileNameBytes = fileHeader.getFileName().getBytes(charset);
            }
            rawIO.writeShortLittleEndian(byteArrayOutputStream, fileNameBytes.length);
            byte[] offsetLocalHeaderBytes = new byte[4];
            if (writeZip64ExtendedInfo) {
                rawIO.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
                System.arraycopy(this.longBuff, 0, offsetLocalHeaderBytes, 0, 4);
            } else {
                rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getOffsetLocalHeader());
                System.arraycopy(this.longBuff, 0, offsetLocalHeaderBytes, 0, 4);
            }
            int extraFieldLength = this.calculateExtraDataRecordsSize(fileHeader, writeZip64ExtendedInfo);
            rawIO.writeShortLittleEndian(byteArrayOutputStream, extraFieldLength);
            String fileComment = fileHeader.getFileComment();
            byte[] fileCommentBytes = new byte[]{};
            if (Zip4jUtil.isStringNotNullAndNotEmpty(fileComment)) {
                fileCommentBytes = fileComment.getBytes(charset);
            }
            rawIO.writeShortLittleEndian(byteArrayOutputStream, fileCommentBytes.length);
            rawIO.writeShortLittleEndian(byteArrayOutputStream, fileHeader.getDiskNumberStart());
            byteArrayOutputStream.write(emptyShortByte);
            byteArrayOutputStream.write(fileHeader.getExternalFileAttributes());
            byteArrayOutputStream.write(offsetLocalHeaderBytes);
            if (fileNameBytes.length > 0) {
                byteArrayOutputStream.write(fileNameBytes);
            }
            if (writeZip64ExtendedInfo) {
                zipModel.setZip64Format(true);
                rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue());
                rawIO.writeShortLittleEndian(byteArrayOutputStream, 28);
                rawIO.writeLongLittleEndian(byteArrayOutputStream, fileHeader.getUncompressedSize());
                rawIO.writeLongLittleEndian(byteArrayOutputStream, fileHeader.getCompressedSize());
                rawIO.writeLongLittleEndian(byteArrayOutputStream, fileHeader.getOffsetLocalHeader());
                rawIO.writeIntLittleEndian(byteArrayOutputStream, fileHeader.getDiskNumberStart());
            }
            if (fileHeader.getAesExtraDataRecord() != null) {
                AESExtraDataRecord aesExtraDataRecord = fileHeader.getAesExtraDataRecord();
                rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)aesExtraDataRecord.getSignature().getValue());
                rawIO.writeShortLittleEndian(byteArrayOutputStream, aesExtraDataRecord.getDataSize());
                rawIO.writeShortLittleEndian(byteArrayOutputStream, aesExtraDataRecord.getAesVersion().getVersionNumber());
                byteArrayOutputStream.write(aesExtraDataRecord.getVendorID().getBytes());
                byte[] aesStrengthBytes = new byte[]{(byte)aesExtraDataRecord.getAesKeyStrength().getRawCode()};
                byteArrayOutputStream.write(aesStrengthBytes);
                rawIO.writeShortLittleEndian(byteArrayOutputStream, aesExtraDataRecord.getCompressionMethod().getCode());
            }
            this.writeRemainingExtraDataRecordsIfPresent(fileHeader, byteArrayOutputStream);
            if (fileCommentBytes.length > 0) {
                byteArrayOutputStream.write(fileCommentBytes);
            }
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private int calculateExtraDataRecordsSize(FileHeader fileHeader, boolean writeZip64ExtendedInfo) throws IOException {
        int extraFieldLength = 0;
        if (writeZip64ExtendedInfo) {
            extraFieldLength += 32;
        }
        if (fileHeader.getAesExtraDataRecord() != null) {
            extraFieldLength += 11;
        }
        if (fileHeader.getExtraDataRecords() != null) {
            for (ExtraDataRecord extraDataRecord : fileHeader.getExtraDataRecords()) {
                if (extraDataRecord.getHeader() == HeaderSignature.AES_EXTRA_DATA_RECORD.getValue() || extraDataRecord.getHeader() == HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue()) continue;
                extraFieldLength += 4 + extraDataRecord.getSizeOfData();
            }
        }
        return extraFieldLength;
    }

    private void writeRemainingExtraDataRecordsIfPresent(FileHeader fileHeader, OutputStream outputStream) throws IOException {
        if (fileHeader.getExtraDataRecords() == null || fileHeader.getExtraDataRecords().size() == 0) {
            return;
        }
        for (ExtraDataRecord extraDataRecord : fileHeader.getExtraDataRecords()) {
            if (extraDataRecord.getHeader() == HeaderSignature.AES_EXTRA_DATA_RECORD.getValue() || extraDataRecord.getHeader() == HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue()) continue;
            this.rawIO.writeShortLittleEndian(outputStream, (int)extraDataRecord.getHeader());
            this.rawIO.writeShortLittleEndian(outputStream, extraDataRecord.getSizeOfData());
            outputStream.write(extraDataRecord.getData());
        }
    }

    private void writeZip64EndOfCentralDirectoryRecord(ZipModel zipModel, int sizeOfCentralDir, long offsetCentralDir, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO) throws IOException {
        long numEntries;
        byte[] emptyShortByte = new byte[]{0, 0};
        rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_RECORD.getValue());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, 44L);
        if (zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() > 0) {
            rawIO.writeShortLittleEndian(byteArrayOutputStream, zipModel.getCentralDirectory().getFileHeaders().get(0).getVersionMadeBy());
            rawIO.writeShortLittleEndian(byteArrayOutputStream, zipModel.getCentralDirectory().getFileHeaders().get(0).getVersionNeededToExtract());
        } else {
            byteArrayOutputStream.write(emptyShortByte);
            byteArrayOutputStream.write(emptyShortByte);
        }
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDiskStartOfCentralDir());
        long numEntriesOnThisDisk = numEntries = (long)zipModel.getCentralDirectory().getFileHeaders().size();
        if (zipModel.isSplitArchive()) {
            numEntriesOnThisDisk = this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        }
        rawIO.writeLongLittleEndian(byteArrayOutputStream, numEntriesOnThisDisk);
        rawIO.writeLongLittleEndian(byteArrayOutputStream, numEntries);
        rawIO.writeLongLittleEndian(byteArrayOutputStream, sizeOfCentralDir);
        rawIO.writeLongLittleEndian(byteArrayOutputStream, offsetCentralDir);
    }

    private void writeZip64EndOfCentralDirectoryLocator(ZipModel zipModel, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO) throws IOException {
        rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_LOCATOR.getValue());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zipModel.getZip64EndOfCentralDirectoryLocator().getNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zipModel.getZip64EndOfCentralDirectoryLocator().getOffsetZip64EndOfCentralDirectoryRecord());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zipModel.getZip64EndOfCentralDirectoryLocator().getTotalNumberOfDiscs());
    }

    private void writeEndOfCentralDirectoryRecord(ZipModel zipModel, int sizeOfCentralDir, long offsetCentralDir, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO, Charset charset) throws IOException {
        long numEntries;
        byte[] longByte = new byte[8];
        rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)HeaderSignature.END_OF_CENTRAL_DIRECTORY.getValue());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDiskStartOfCentralDir());
        long numEntriesOnThisDisk = numEntries = (long)zipModel.getCentralDirectory().getFileHeaders().size();
        if (zipModel.isSplitArchive()) {
            numEntriesOnThisDisk = this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        }
        if (numEntriesOnThisDisk > 65535L) {
            numEntriesOnThisDisk = 65535L;
        }
        rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)numEntriesOnThisDisk);
        if (numEntries > 65535L) {
            numEntries = 65535L;
        }
        rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)numEntries);
        rawIO.writeIntLittleEndian(byteArrayOutputStream, sizeOfCentralDir);
        if (offsetCentralDir > 0xFFFFFFFFL) {
            rawIO.writeLongLittleEndian(longByte, 0, 0xFFFFFFFFL);
            byteArrayOutputStream.write(longByte, 0, 4);
        } else {
            rawIO.writeLongLittleEndian(longByte, 0, offsetCentralDir);
            byteArrayOutputStream.write(longByte, 0, 4);
        }
        String comment = zipModel.getEndOfCentralDirectoryRecord().getComment();
        if (Zip4jUtil.isStringNotNullAndNotEmpty(comment)) {
            byte[] commentBytes = comment.getBytes(charset);
            rawIO.writeShortLittleEndian(byteArrayOutputStream, commentBytes.length);
            byteArrayOutputStream.write(commentBytes);
        } else {
            rawIO.writeShortLittleEndian(byteArrayOutputStream, 0);
        }
    }

    private long countNumberOfFileHeaderEntriesOnDisk(List<FileHeader> fileHeaders, int numOfDisk) throws ZipException {
        if (fileHeaders == null) {
            throw new ZipException("file headers are null, cannot calculate number of entries on this disk");
        }
        int noEntries = 0;
        for (FileHeader fileHeader : fileHeaders) {
            if (fileHeader.getDiskNumberStart() != numOfDisk) continue;
            ++noEntries;
        }
        return noEntries;
    }

    private boolean isZip64Entry(FileHeader fileHeader) {
        return fileHeader.getCompressedSize() >= 0xFFFFFFFFL || fileHeader.getUncompressedSize() >= 0xFFFFFFFFL || fileHeader.getOffsetLocalHeader() >= 0xFFFFFFFFL;
    }
}

