/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.Locale;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.oasis.ContentBuilder;
import net.sf.jasperreports.engine.export.oasis.DocumentBuilder;
import net.sf.jasperreports.engine.export.oasis.FileBufferedOasisZip;
import net.sf.jasperreports.engine.export.oasis.GenericElementOdsHandler;
import net.sf.jasperreports.engine.export.oasis.JROdsExporterContext;
import net.sf.jasperreports.engine.export.oasis.JROdsExporterNature;
import net.sf.jasperreports.engine.export.oasis.JROpenDocumentExporterParameter;
import net.sf.jasperreports.engine.export.oasis.OasisZip;
import net.sf.jasperreports.engine.export.oasis.StyleBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.TableBuilder;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JROdsExporter
extends JRXlsAbstractExporter {
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected OasisZip oasisZip;
    protected ExportZipEntry tempBodyEntry;
    protected ExportZipEntry tempStyleEntry;
    protected WriterHelper tempBodyWriter;
    protected WriterHelper tempStyleWriter;
    protected StyleCache styleCache;
    protected DocumentBuilder documentBuilder;
    protected TableBuilder tableBuilder;
    protected boolean startPage;
    protected boolean flexibleRowHeight;
    private static final Log log = LogFactory.getLog(JROdsExporter.class);
    protected static final String ODS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.ods.";
    public static final String ODS_EXPORTER_KEY = "net.sf.jasperreports.ods";

    @Override
    protected void setBackground() {
    }

    @Override
    protected void openWorkbook(OutputStream os) throws JRException, IOException {
        this.oasisZip = new FileBufferedOasisZip("spreadsheet");
        this.tempBodyEntry = new FileBufferedZipEntry(null);
        this.tempStyleEntry = new FileBufferedZipEntry(null);
        this.tempBodyWriter = new WriterHelper(this.jasperReportsContext, this.tempBodyEntry.getWriter());
        this.tempStyleWriter = new WriterHelper(this.jasperReportsContext, this.tempStyleEntry.getWriter());
        this.documentBuilder = new OdsDocumentBuilder(this.oasisZip);
        this.styleCache = new StyleCache(this.jasperReportsContext, this.tempStyleWriter, this.fontMap, this.getExporterKey());
        WriterHelper stylesWriter = new WriterHelper(this.jasperReportsContext, this.oasisZip.getStylesEntry().getWriter());
        StyleBuilder styleBuilder = new StyleBuilder(this.jasperPrintList, stylesWriter);
        styleBuilder.build();
        stylesWriter.close();
    }

    @Override
    protected void createSheet(CutsInfo xCuts, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        this.closeSheet();
        this.startPage = true;
        this.tableBuilder = new OdsTableBuilder(this.documentBuilder, this.jasperPrint, this.reportIndex, this.pageIndex, this.tempBodyWriter, this.tempStyleWriter, this.styleCache);
        this.tableBuilder.buildTableStyle(xCuts.getLastCutOffset());
        this.tableBuilder.buildTableHeader();
    }

    protected void closeSheet() {
        if (this.tableBuilder != null) {
            this.tableBuilder.buildRowFooter();
            this.tableBuilder.buildTableFooter();
        }
    }

    @Override
    protected void closeWorkbook(OutputStream os) throws JRException, IOException {
        this.closeSheet();
        this.tempBodyWriter.flush();
        this.tempStyleWriter.flush();
        this.tempBodyWriter.close();
        this.tempStyleWriter.close();
        ContentBuilder contentBuilder = new ContentBuilder(this.oasisZip.getContentEntry(), this.tempStyleEntry, this.tempBodyEntry, this.styleCache.getFontFaces(), "spreadsheet");
        contentBuilder.build();
        this.tempStyleEntry.dispose();
        this.tempBodyEntry.dispose();
        this.oasisZip.zipEntries(os);
        this.oasisZip.dispose();
    }

    @Override
    protected void setColumnWidth(int col, int width, boolean autoFit) {
        this.tableBuilder.buildColumnStyle(col - 1, width);
        this.tableBuilder.buildColumnHeader(col - 1);
        this.tableBuilder.buildColumnFooter();
    }

    @Override
    protected void setRowHeight(int rowIndex, int lastRowHeight, Cut yCut, XlsRowLevelInfo levelInfo) throws JRException {
        this.tableBuilder.buildRowStyle(rowIndex, this.flexibleRowHeight ? -1 : lastRowHeight);
        this.tableBuilder.buildRow(rowIndex);
    }

    @Override
    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        this.tempBodyWriter.write("<table:table-cell");
        if (gridCell == null) {
            this.tempBodyWriter.write(" table:style-name=\"empty-cell\"");
        } else {
            this.tempBodyWriter.write(" table:style-name=\"" + this.styleCache.getCellStyle(gridCell) + "\"");
        }
        this.tempBodyWriter.write("/>\n");
    }

    @Override
    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) throws JRException {
        ElementGridCell elementGridCell = (ElementGridCell)occupiedGridCell.getOccupier();
        this.addBlankCell(elementGridCell, colIndex, rowIndex);
    }

    @Override
    public void exportText(JRPrintText text, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.tableBuilder.exportText(text, gridCell);
    }

    @Override
    public void exportImage(JRPrintImage image, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        int topPadding = Math.max(image.getLineBox().getTopPadding(), Math.round(image.getLineBox().getTopPen().getLineWidth().floatValue()));
        int leftPadding = Math.max(image.getLineBox().getLeftPadding(), Math.round(image.getLineBox().getLeftPen().getLineWidth().floatValue()));
        int bottomPadding = Math.max(image.getLineBox().getBottomPadding(), Math.round(image.getLineBox().getBottomPen().getLineWidth().floatValue()));
        int rightPadding = Math.max(image.getLineBox().getRightPadding(), Math.round(image.getLineBox().getRightPen().getLineWidth().floatValue()));
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        int width = availableImageWidth;
        int height = availableImageHeight;
        int xoffset = 0;
        int yoffset = 0;
        this.tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        Renderable renderer = image.getRenderable();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE && !image.isLazy()) {
                renderer = RenderableUtil.getInstance(this.getJasperReportsContext()).getOnErrorRendererForImageData(renderer, image.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            float xalignFactor = this.tableBuilder.getXAlignFactor(image);
            float yalignFactor = this.tableBuilder.getYAlignFactor(image);
            switch (image.getScaleImageValue()) {
                case FILL_FRAME: {
                    width = availableImageWidth;
                    height = availableImageHeight;
                    xoffset = 0;
                    yoffset = 0;
                    break;
                }
                default: {
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        Renderable tmpRenderer = RenderableUtil.getInstance(this.getJasperReportsContext()).getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.getJasperReportsContext());
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    if (availableImageHeight > 0) {
                        double ratio = normalWidth / normalHeight;
                        if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                            width = availableImageWidth;
                            height = (int)((double)width / ratio);
                        } else {
                            height = availableImageHeight;
                            width = (int)(ratio * (double)height);
                        }
                    }
                    xoffset = (int)(xalignFactor * (float)(availableImageWidth - width));
                    yoffset = (int)(yalignFactor * (float)(availableImageHeight - height));
                }
            }
            this.documentBuilder.insertPageAnchor(this.tableBuilder);
            if (image.getAnchorName() != null) {
                this.tableBuilder.exportAnchor(JRStringUtil.xmlEncode(image.getAnchorName()));
            }
            boolean startedHyperlink = this.tableBuilder.startHyperlink(image, false);
            String cellAddress = this.getCellAddress(rowIndex + gridCell.getRowSpan() + 1, colIndex + gridCell.getColSpan());
            cellAddress = cellAddress == null ? "" : "table:end-cell-address=\"" + cellAddress + "\" ";
            this.tempBodyWriter.write("<draw:frame text:anchor-type=\"frame\" draw:style-name=\"" + this.styleCache.getGraphicStyle(image) + "\" " + cellAddress + "table:end-x=\"0in\" " + "table:end-y=\"0in\" " + "svg:x=\"0in\" " + "svg:y=\"0in\" " + "svg:width=\"" + LengthUtil.inchRound(image.getWidth()) + "in\" " + "svg:height=\"" + LengthUtil.inchRound(image.getHeight()) + "in\"" + ">");
            this.tempBodyWriter.write("<draw:image ");
            String imagePath = this.documentBuilder.getImagePath(renderer, image, gridCell);
            this.tempBodyWriter.write(" xlink:href=\"" + JRStringUtil.xmlEncode(imagePath) + "\"");
            this.tempBodyWriter.write(" xlink:type=\"simple\"");
            this.tempBodyWriter.write(" xlink:show=\"embed\"");
            this.tempBodyWriter.write(" xlink:actuate=\"onLoad\"");
            this.tempBodyWriter.write("/>\n");
            this.tempBodyWriter.write("</draw:frame>");
            if (startedHyperlink) {
                this.tableBuilder.endHyperlink(false);
            }
        }
        this.tableBuilder.buildCellFooter();
    }

    protected String getCellAddress(int row, int col) {
        String address = null;
        if (row > 0 && row < 0x100001 && col > -1 && col < 16384) {
            address = this.getColumnName(col) + row;
        }
        return address;
    }

    @Override
    protected String getColumnName(int colIndex) {
        String colName = null;
        if (colIndex > -1 && colIndex < 16384) {
            colName = colIndex > 675 ? String.valueOf((char)(colIndex / 676 + 64)) + this.getColumnName(colIndex % 676) : (colIndex > 25 ? String.valueOf((char)(colIndex / 26 + 64)) + this.getColumnName(colIndex % 26) : String.valueOf((char)(colIndex % 26 + 65)));
        }
        return colName;
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement rectangle, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.tableBuilder.exportRectangle(rectangle, gridCell);
    }

    @Override
    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = null;
        float ratio = line.getWidth() / line.getHeight();
        pen = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getTopPen() : box.getBottomPen()) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getLeftPen() : box.getRightPen());
        pen.setLineColor(line.getLinePen().getLineColor());
        pen.setLineStyle(line.getLinePen().getLineStyleValue());
        pen.setLineWidth(line.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        this.tempBodyWriter.write("<text:p>");
        this.tempBodyWriter.write("</text:p>");
        this.tableBuilder.buildCellFooter();
    }

    @Override
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
        this.addBlankCell(cell, colIndex, rowIndex);
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        GenericElementOdsHandler handler = (GenericElementOdsHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), ODS_EXPORTER_KEY);
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext(this.tableBuilder);
            handler.exportElement(exporterContext, element, gridCell, colIndex, rowIndex, emptyCols, yCutsRow, layout);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No ODS generic element handler for " + element.getGenericType()));
        }
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex, boolean isRowEdge, boolean isColumnEdge) {
    }

    @Override
    protected void setSheetName(String sheetName) {
    }

    @Override
    protected void setAutoFilter(String autoFilterRange) {
    }

    @Override
    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
    }

    @Override
    protected void setScale(Integer scale) {
    }

    public JROdsExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JROdsExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    protected void setParameters() {
        super.setParameters();
        this.nature = new JROdsExporterNature(this.jasperReportsContext, this.filter, this.isIgnoreGraphics, this.isIgnorePageMargins);
    }

    @Override
    public String getExporterKey() {
        return ODS_EXPORTER_KEY;
    }

    protected JRPrintImage getPrintImageForGenericElement(JRGenericPrintElement genericPrintElement) throws JRException {
        return ((GenericElementOdsHandler)GenericElementHandlerEnviroment.getInstance(this.jasperReportsContext).getElementHandler(genericPrintElement.getGenericType(), ODS_EXPORTER_KEY)).getImage(new ExporterContext(null), genericPrintElement);
    }

    protected void setFlexibleRowHeight() {
        this.flexibleRowHeight = this.getBooleanParameter(JROpenDocumentExporterParameter.ODS_FLEXIBLE_ROW_HEIGHT, "net.sf.jasperreports.export.ods.flexible.row.height", false);
    }

    protected void insertPageAnchor(TableBuilder tableBuilder) {
        if (this.startPage) {
            tableBuilder.exportAnchor(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (this.pageIndex + 1));
            this.startPage = false;
        }
    }

    protected class OdsTableBuilder
    extends TableBuilder {
        protected OdsTableBuilder(DocumentBuilder documentBuilder, JasperPrint jasperPrint, int reportIndex, int pageIndex, WriterHelper bodyWriter, WriterHelper styleWriter, StyleCache styleCache) {
            super(documentBuilder, jasperPrint, reportIndex, pageIndex, bodyWriter, styleWriter, styleCache);
        }

        @Override
        protected String getIgnoreHyperlinkProperty() {
            return "net.sf.jasperreports.export.xls.ignore.hyperlink";
        }

        @Override
        protected void exportTextContents(JRPrintText textElement) {
            String href = null;
            String ignLnkPropName = this.getIgnoreHyperlinkProperty();
            Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(ignLnkPropName, textElement);
            if (ignoreHyperlink == null) {
                ignoreHyperlink = JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getBooleanProperty(JROdsExporter.this.jasperPrint, ignLnkPropName, false);
            }
            if (!ignoreHyperlink.booleanValue()) {
                href = JROdsExporter.this.documentBuilder.getHyperlinkURL(textElement);
            }
            if (href == null) {
                this.exportStyledText(textElement, false);
            } else {
                JRStyledText styledText = JROdsExporter.this.getStyledText(textElement);
                if (styledText != null && styledText.length() > 0) {
                    String text = styledText.getText();
                    Locale locale = JROdsExporter.this.getTextLocale(textElement);
                    int runLimit = 0;
                    AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
                    while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
                        String runText = text.substring(iterator.getIndex(), runLimit);
                        this.startTextSpan(iterator.getAttributes(), runText, locale);
                        this.writeHyperlink(textElement, href, true);
                        this.writeText(runText);
                        this.endHyperlink(true);
                        this.endTextSpan();
                        iterator.setIndex(runLimit);
                    }
                }
            }
        }
    }

    protected class OdsDocumentBuilder
    extends DocumentBuilder {
        public OdsDocumentBuilder(OasisZip oasisZip) {
            super(oasisZip);
        }

        @Override
        public JRStyledText getStyledText(JRPrintText text) {
            return JROdsExporter.this.getStyledText(text);
        }

        @Override
        public Locale getTextLocale(JRPrintText text) {
            return JROdsExporter.this.getTextLocale(text);
        }

        @Override
        public String getInvalidCharReplacement() {
            return JROdsExporter.this.invalidCharReplacement;
        }

        @Override
        protected void insertPageAnchor(TableBuilder tableBuilder) {
            JROdsExporter.this.insertPageAnchor(tableBuilder);
        }

        @Override
        protected JRHyperlinkProducer getHyperlinkProducer(JRPrintHyperlink link) {
            return JROdsExporter.this.getHyperlinkProducer(link);
        }

        @Override
        protected JasperReportsContext getJasperReportsContext() {
            return JROdsExporter.this.getJasperReportsContext();
        }

        @Override
        protected int getReportIndex() {
            return JROdsExporter.this.reportIndex;
        }

        @Override
        protected int getPageIndex() {
            return JROdsExporter.this.pageIndex;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JROdsExporterContext {
        TableBuilder tableBuilder;

        public ExporterContext(TableBuilder tableBuidler) {
            super(JROdsExporter.this);
            this.tableBuilder = null;
            this.tableBuilder = tableBuidler;
        }

        @Override
        public TableBuilder getTableBuilder() {
            return this.tableBuilder;
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JROdsExporter.ODS_EXPORTER_PROPERTIES_PREFIX;
        }
    }
}

