/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.BasicStroke;
import java.awt.Stroke;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.PenEnum;

public final class JRPenUtil {
    public static void setLinePenFromPen(Byte pen, JRPen linePen) {
        JRPenUtil.setLinePenFromPen(PenEnum.getByValue(pen), linePen);
    }

    public static void setLinePenFromPen(PenEnum pen, JRPen linePen) {
        if (pen != null) {
            switch (pen) {
                case THIN: {
                    linePen.setLineWidth(0.5f);
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                    break;
                }
                case ONE_POINT: {
                    linePen.setLineWidth(1.0f);
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                    break;
                }
                case TWO_POINT: {
                    linePen.setLineWidth(2.0f);
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                    break;
                }
                case FOUR_POINT: {
                    linePen.setLineWidth(4.0f);
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                    break;
                }
                case DOTTED: {
                    linePen.setLineWidth(1.0f);
                    linePen.setLineStyle(LineStyleEnum.DASHED);
                    break;
                }
                case NONE: {
                    linePen.setLineWidth(0.0f);
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                }
            }
        }
    }

    public static byte getPenFromLinePen(JRPen linePen) {
        float lineWidth = linePen.getLineWidth().floatValue();
        if (lineWidth <= 0.0f) {
            return PenEnum.NONE.getValue();
        }
        if (0.0f < lineWidth && lineWidth < 1.0f) {
            return PenEnum.THIN.getValue();
        }
        if (1.0f <= lineWidth && lineWidth < 2.0f) {
            if (linePen.getLineStyleValue() == LineStyleEnum.DASHED) {
                return PenEnum.DOTTED.getValue();
            }
            return PenEnum.ONE_POINT.getValue();
        }
        if (2.0f <= lineWidth && lineWidth < 4.0f) {
            return PenEnum.TWO_POINT.getValue();
        }
        return PenEnum.FOUR_POINT.getValue();
    }

    public static Byte getOwnPenFromLinePen(JRPen linePen) {
        if (linePen.getOwnLineWidth() == null && linePen.getOwnLineStyleValue() == null) {
            return null;
        }
        return new Byte(JRPenUtil.getPenFromLinePen(linePen));
    }

    public static Stroke getStroke(JRPen pen, int lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            LineStyleEnum lineStyle = pen.getLineStyleValue();
            switch (lineStyle) {
                case DOUBLE: {
                    return new BasicStroke(lineWidth / 3.0f, lineCap, 0);
                }
                case DOTTED: {
                    switch (lineCap) {
                        case 2: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{0.0f, 2.0f * lineWidth}, 0.0f);
                        }
                        case 0: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{lineWidth, lineWidth}, 0.0f);
                        }
                    }
                }
                case DASHED: {
                    switch (lineCap) {
                        case 2: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{4.0f * lineWidth, 4.0f * lineWidth}, 0.0f);
                        }
                        case 0: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{5.0f * lineWidth, 3.0f * lineWidth}, 0.0f);
                        }
                    }
                }
            }
            return new BasicStroke(lineWidth, lineCap, 0);
        }
        return null;
    }

    private JRPenUtil() {
    }
}

