/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.Grid;
import net.sf.jasperreports.engine.export.GridRow;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.ContentBuilder;
import net.sf.jasperreports.engine.export.oasis.DocumentBuilder;
import net.sf.jasperreports.engine.export.oasis.FileBufferedOasisZip;
import net.sf.jasperreports.engine.export.oasis.GenericElementOdtHandler;
import net.sf.jasperreports.engine.export.oasis.JROdtExporterContext;
import net.sf.jasperreports.engine.export.oasis.JROdtExporterNature;
import net.sf.jasperreports.engine.export.oasis.OasisZip;
import net.sf.jasperreports.engine.export.oasis.StyleBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.TableBuilder;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.OdtExporterConfiguration;
import net.sf.jasperreports.export.OdtReportConfiguration;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersOutputStreamExporterOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JROdtExporter
extends JRAbstractExporter<OdtReportConfiguration, OdtExporterConfiguration, OutputStreamExporterOutput, JROdtExporterContext> {
    private static final Log log = LogFactory.getLog(JROdtExporter.class);
    public static final String ODT_EXPORTER_KEY = "net.sf.jasperreports.odt";
    protected static final String ODT_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.odt.";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.odt.ignore.hyperlink";
    protected WriterHelper tempBodyWriter;
    protected WriterHelper tempStyleWriter;
    protected int reportIndex;
    protected int pageIndex;
    protected int tableIndex;
    protected boolean startPage;
    protected String invalidCharReplacement;
    protected LinkedList<Color> backcolorStack = new LinkedList();
    protected Color backcolor;
    protected DocumentBuilder documentBuilder;
    protected StyleCache styleCache;
    protected ExporterNature nature;
    protected Map<Integer, String> rowStyles = new HashMap<Integer, String>();
    protected Map<Integer, String> columnStyles = new HashMap<Integer, String>();

    public JROdtExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JROdtExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext(null);
    }

    @Override
    protected Class<OdtExporterConfiguration> getConfigurationInterface() {
        return OdtExporterConfiguration.class;
    }

    @Override
    protected Class<OdtReportConfiguration> getItemConfigurationInterface() {
        return OdtReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersOutputStreamExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        OutputStream outputStream = ((OutputStreamExporterOutput)this.getExporterOutput()).getOutputStream();
        try {
            this.exportReportToOasisZip(outputStream);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            ((OutputStreamExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
        this.invalidCharReplacement = this.jasperPrint.hasProperties() && this.jasperPrint.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") ? this.jasperPrint.getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") : this.getPropertiesUtil().getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars", this.jasperPrint);
        this.nature = new JROdtExporterNature(this.getJasperReportsContext(), this.filter);
    }

    protected void exportReportToOasisZip(OutputStream os) throws JRException, IOException {
        FileBufferedOasisZip oasisZip = new FileBufferedOasisZip("text");
        FileBufferedZipEntry tempBodyEntry = new FileBufferedZipEntry(null);
        FileBufferedZipEntry tempStyleEntry = new FileBufferedZipEntry(null);
        this.tempBodyWriter = new WriterHelper(this.jasperReportsContext, tempBodyEntry.getWriter());
        this.tempStyleWriter = new WriterHelper(this.jasperReportsContext, tempStyleEntry.getWriter());
        this.documentBuilder = new OdtDocumentBuilder(oasisZip);
        this.styleCache = new StyleCache(this.jasperReportsContext, this.tempStyleWriter, this.getExporterKey());
        WriterHelper stylesWriter = new WriterHelper(this.jasperReportsContext, oasisZip.getStylesEntry().getWriter());
        List<ExporterInputItem> items = this.exporterInput.getItems();
        StyleBuilder styleBuilder = new StyleBuilder(this.exporterInput, stylesWriter);
        styleBuilder.build();
        stylesWriter.close();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.rowStyles.clear();
            this.columnStyles.clear();
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                JRPrintPage page = null;
                this.pageIndex = startPageIndex;
                while (this.pageIndex <= endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = pages.get(this.pageIndex);
                    this.exportPage(page);
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.tempBodyWriter.flush();
        this.tempStyleWriter.flush();
        this.tempBodyWriter.close();
        this.tempStyleWriter.close();
        ContentBuilder contentBuilder = new ContentBuilder(oasisZip.getContentEntry(), tempStyleEntry, tempBodyEntry, this.styleCache.getFontFaces(), "text");
        contentBuilder.build();
        tempStyleEntry.dispose();
        tempBodyEntry.dispose();
        oasisZip.zipEntries(os);
        oasisZip.dispose();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.startPage = true;
        Object configuration = this.getCurrentItemConfiguration();
        JRGridLayout layout = new JRGridLayout(this.nature, page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), configuration.getOffsetX() == null ? 0 : configuration.getOffsetX(), configuration.getOffsetY() == null ? 0 : configuration.getOffsetY(), null);
        this.exportGrid(layout, null);
        JRExportProgressMonitor progressMonitor = configuration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportGrid(JRGridLayout gridLayout, JRPrintElementIndex frameIndex) throws IOException, JRException {
        boolean isFlexibleRowHeight = ((OdtReportConfiguration)this.getCurrentItemConfiguration()).isFlexibleRowHeight();
        CutsInfo xCuts = gridLayout.getXCuts();
        Grid grid = gridLayout.getGrid();
        TableBuilder tableBuilder = frameIndex == null ? new TableBuilder(this.documentBuilder, this.jasperPrint, this.reportIndex, this.pageIndex, this.tempBodyWriter, this.tempStyleWriter, this.styleCache, this.rowStyles, this.columnStyles) : new TableBuilder(this.documentBuilder, this.jasperPrint, frameIndex.toString(), this.tempBodyWriter, this.tempStyleWriter, this.styleCache, this.rowStyles, this.columnStyles);
        tableBuilder.buildTableStyle(gridLayout.getWidth());
        tableBuilder.buildTableHeader();
        for (int col = 1; col < xCuts.size(); ++col) {
            tableBuilder.buildColumnStyle(col - 1, xCuts.getCutOffset(col) - xCuts.getCutOffset(col - 1));
            tableBuilder.buildColumnHeader(xCuts.getCutOffset(col) - xCuts.getCutOffset(col - 1));
            tableBuilder.buildColumnFooter();
        }
        int rowCount = grid.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            int emptyCellColSpan = 0;
            int rowHeight = gridLayout.getRowHeight(row);
            tableBuilder.buildRowStyle(row, isFlexibleRowHeight ? -1 : rowHeight);
            tableBuilder.buildRowHeader(isFlexibleRowHeight ? -1 : rowHeight);
            GridRow gridRow = grid.getRow(row);
            int rowSize = gridRow.size();
            for (int col = 0; col < rowSize; ++col) {
                JRExporterGridCell gridCell = gridRow.get(col);
                if (gridCell.getType() == 2) {
                    if (emptyCellColSpan > 0) {
                        emptyCellColSpan = 0;
                    }
                    this.exportOccupiedCells(1);
                    continue;
                }
                if (gridCell.getType() == 3) {
                    JRPrintElement element;
                    if (emptyCellColSpan > 0) {
                        emptyCellColSpan = 0;
                    }
                    if ((element = gridCell.getElement()) instanceof JRPrintLine) {
                        this.exportLine(tableBuilder, (JRPrintLine)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintRectangle) {
                        this.exportRectangle(tableBuilder, (JRPrintRectangle)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintEllipse) {
                        this.exportEllipse(tableBuilder, (JRPrintEllipse)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintImage) {
                        this.exportImage(tableBuilder, (JRPrintImage)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintText) {
                        this.exportText(tableBuilder, (JRPrintText)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintFrame) {
                        this.exportFrame(tableBuilder, (JRPrintFrame)element, gridCell);
                        continue;
                    }
                    if (!(element instanceof JRGenericPrintElement)) continue;
                    this.exportGenericElement(tableBuilder, (JRGenericPrintElement)element, gridCell);
                    continue;
                }
                ++emptyCellColSpan;
                this.exportEmptyCell(gridCell, 1);
            }
            tableBuilder.buildRowFooter();
        }
        tableBuilder.buildTableFooter();
    }

    private void exportOccupiedCells(int count) {
        for (int i = 0; i < count; ++i) {
            this.tempBodyWriter.write("<table:covered-table-cell/>\n");
        }
    }

    private void exportEmptyCell(JRExporterGridCell gridCell, int emptyCellColSpan) throws IOException {
        this.tempBodyWriter.write("<table:table-cell");
        this.tempBodyWriter.write(" table:style-name=\"" + this.styleCache.getCellStyle(gridCell) + "\"");
        if (emptyCellColSpan > 1) {
            this.tempBodyWriter.write(" table:number-columns-spanned=\"" + emptyCellColSpan + "\"");
        }
        this.tempBodyWriter.write("/>\n");
        this.exportOccupiedCells(emptyCellColSpan - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(TableBuilder tableBuilder, JRPrintFrame frame, JRExporterGridCell gridCell) throws IOException, JRException {
        boolean appendBackcolor;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        boolean bl = appendBackcolor = frame.getModeValue() == ModeEnum.OPAQUE && (this.backcolor == null || frame.getBackcolor().getRGB() != this.backcolor.getRGB());
        if (appendBackcolor) {
            this.setBackcolor(frame.getBackcolor());
        }
        try {
            JRGridLayout layout = ((ElementGridCell)gridCell).getLayout();
            JRPrintElementIndex frameIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getElementAddress());
            this.exportGrid(layout, frameIndex);
        }
        finally {
            if (appendBackcolor) {
                this.restoreBackcolor();
            }
        }
        tableBuilder.buildCellFooter();
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = this.backcolorStack.removeLast();
    }

    protected void exportRectangle(TableBuilder tableBuilder, JRPrintRectangle rectangle, JRExporterGridCell gridCell) {
        tableBuilder.exportRectangle(rectangle, gridCell);
    }

    protected void exportLine(TableBuilder tableBuilder, JRPrintLine line, JRExporterGridCell gridCell) {
        tableBuilder.exportLine(line, gridCell);
    }

    protected void exportEllipse(TableBuilder tableBuilder, JRPrintEllipse ellipse, JRExporterGridCell gridCell) {
        tableBuilder.exportEllipse(ellipse, gridCell);
    }

    public void exportText(TableBuilder tableBuilder, JRPrintText text, JRExporterGridCell gridCell) {
        tableBuilder.exportText(text, gridCell);
    }

    public void exportImage(TableBuilder tableBuilder, JRPrintImage image, JRExporterGridCell gridCell) throws JRException {
        int topPadding = Math.max(image.getLineBox().getTopPadding(), Math.round(image.getLineBox().getTopPen().getLineWidth().floatValue()));
        int leftPadding = Math.max(image.getLineBox().getLeftPadding(), Math.round(image.getLineBox().getLeftPen().getLineWidth().floatValue()));
        int bottomPadding = Math.max(image.getLineBox().getBottomPadding(), Math.round(image.getLineBox().getBottomPen().getLineWidth().floatValue()));
        int rightPadding = Math.max(image.getLineBox().getRightPadding(), Math.round(image.getLineBox().getRightPen().getLineWidth().floatValue()));
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        int width = availableImageWidth;
        int height = availableImageHeight;
        int xoffset = 0;
        int yoffset = 0;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        Renderable renderer = image.getRenderable();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE && !image.isLazy()) {
                renderer = RenderableUtil.getInstance(this.getJasperReportsContext()).getOnErrorRendererForImageData(renderer, image.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            float xalignFactor = tableBuilder.getXAlignFactor(image);
            float yalignFactor = tableBuilder.getYAlignFactor(image);
            switch (image.getScaleImageValue()) {
                case FILL_FRAME: {
                    width = availableImageWidth;
                    height = availableImageHeight;
                    xoffset = 0;
                    yoffset = 0;
                    break;
                }
                default: {
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        Renderable tmpRenderer = RenderableUtil.getInstance(this.getJasperReportsContext()).getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.getJasperReportsContext());
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    if (availableImageHeight > 0) {
                        double ratio = normalWidth / normalHeight;
                        if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                            width = availableImageWidth;
                            height = (int)((double)width / ratio);
                        } else {
                            height = availableImageHeight;
                            width = (int)(ratio * (double)height);
                        }
                    }
                    xoffset = (int)(xalignFactor * (float)(availableImageWidth - width));
                    yoffset = (int)(yalignFactor * (float)(availableImageHeight - height));
                }
            }
            this.tempBodyWriter.write("<text:p>");
            this.documentBuilder.insertPageAnchor(tableBuilder);
            if (image.getAnchorName() != null) {
                tableBuilder.exportAnchor(JRStringUtil.xmlEncode(image.getAnchorName()));
            }
            boolean startedHyperlink = tableBuilder.startHyperlink(image, false);
            this.tempBodyWriter.write("<draw:frame text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(image) + "\" " + "svg:x=\"" + LengthUtil.inch(leftPadding + xoffset) + "in\" " + "svg:y=\"" + LengthUtil.inch(topPadding + yoffset) + "in\" " + "svg:width=\"" + LengthUtil.inch(width) + "in\" " + "svg:height=\"" + LengthUtil.inch(height) + "in\">");
            this.tempBodyWriter.write("<draw:image ");
            String imagePath = this.documentBuilder.getImagePath(renderer, image, gridCell);
            this.tempBodyWriter.write(" xlink:href=\"" + JRStringUtil.xmlEncode(imagePath) + "\"");
            this.tempBodyWriter.write(" xlink:type=\"simple\"");
            this.tempBodyWriter.write(" xlink:show=\"embed\"");
            this.tempBodyWriter.write(" xlink:actuate=\"onLoad\"");
            this.tempBodyWriter.write("/>\n");
            this.tempBodyWriter.write("</draw:frame>");
            if (startedHyperlink) {
                tableBuilder.endHyperlink(false);
            }
            this.tempBodyWriter.write("</text:p>");
        }
        tableBuilder.buildCellFooter();
    }

    protected void insertPageAnchor(TableBuilder tableBuilder) {
        if (this.startPage) {
            tableBuilder.exportAnchor("JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1));
            this.startPage = false;
        }
    }

    protected void exportGenericElement(TableBuilder tableBuilder, JRGenericPrintElement element, JRExporterGridCell gridCell) throws IOException, JRException {
        GenericElementOdtHandler handler = (GenericElementOdtHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), this.getExporterKey());
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext(tableBuilder);
            handler.exportElement(exporterContext, element, gridCell);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No ODT generic element handler for " + element.getGenericType()));
        }
    }

    @Override
    public String getExporterKey() {
        return ODT_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return ODT_EXPORTER_PROPERTIES_PREFIX;
    }

    protected class OdtDocumentBuilder
    extends DocumentBuilder {
        public OdtDocumentBuilder(OasisZip oasisZip) {
            super(oasisZip);
        }

        @Override
        public JRStyledText getStyledText(JRPrintText text) {
            return JROdtExporter.this.getStyledText(text);
        }

        @Override
        public Locale getTextLocale(JRPrintText text) {
            return JROdtExporter.this.getTextLocale(text);
        }

        @Override
        public String getInvalidCharReplacement() {
            return JROdtExporter.this.invalidCharReplacement;
        }

        @Override
        protected void insertPageAnchor(TableBuilder tableBuilder) {
            JROdtExporter.this.insertPageAnchor(tableBuilder);
        }

        @Override
        protected JRHyperlinkProducer getHyperlinkProducer(JRPrintHyperlink link) {
            return JROdtExporter.this.getHyperlinkProducer(link);
        }

        @Override
        protected JasperReportsContext getJasperReportsContext() {
            return JROdtExporter.this.getJasperReportsContext();
        }

        @Override
        protected int getReportIndex() {
            return JROdtExporter.this.reportIndex;
        }

        @Override
        protected int getPageIndex() {
            return JROdtExporter.this.pageIndex;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JROdtExporterContext {
        TableBuilder tableBuilder;

        public ExporterContext(TableBuilder tableBuidler) {
            super(JROdtExporter.this);
            this.tableBuilder = null;
            this.tableBuilder = tableBuidler;
        }

        @Override
        public TableBuilder getTableBuilder() {
            return this.tableBuilder;
        }
    }
}

