/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j.util;

import java.io.File;
import java.io.IOException;
import net.sourceforge.tess4j.util.PdfBoxUtilities;
import net.sourceforge.tess4j.util.PdfGsUtilities;

public class PdfUtilities {
    public static final String PDF_LIBRARY = "pdf.library";
    public static final String PDFBOX = "pdfbox";

    public static File convertPdf2Tiff(File file) throws IOException {
        if (PDFBOX.equals(System.getProperty(PDF_LIBRARY))) {
            return PdfBoxUtilities.convertPdf2Tiff(file);
        }
        try {
            return PdfGsUtilities.convertPdf2Tiff(file);
        }
        catch (Exception exception) {
            System.setProperty(PDF_LIBRARY, PDFBOX);
            return PdfUtilities.convertPdf2Tiff(file);
        }
    }

    public static File[] convertPdf2Png(File file) throws IOException {
        if (PDFBOX.equals(System.getProperty(PDF_LIBRARY))) {
            return PdfBoxUtilities.convertPdf2Png(file);
        }
        try {
            return PdfGsUtilities.convertPdf2Png(file);
        }
        catch (Exception exception) {
            System.setProperty(PDF_LIBRARY, PDFBOX);
            return PdfUtilities.convertPdf2Png(file);
        }
    }

    public static void splitPdf(String string, String string2, String string3, String string4) {
        if (string3.trim().isEmpty()) {
            string3 = "0";
        }
        if (string4.trim().isEmpty()) {
            string4 = "0";
        }
        PdfUtilities.splitPdf(new File(string), new File(string2), Integer.parseInt(string3), Integer.parseInt(string4));
    }

    public static void splitPdf(File file, File file2, int n, int n2) {
        if (PDFBOX.equals(System.getProperty(PDF_LIBRARY))) {
            PdfBoxUtilities.splitPdf(file, file2, n, n2);
        } else {
            try {
                PdfGsUtilities.splitPdf(file, file2, n, n2);
            }
            catch (Exception exception) {
                System.setProperty(PDF_LIBRARY, PDFBOX);
                PdfUtilities.splitPdf(file, file2, n, n2);
            }
        }
    }

    public static int getPdfPageCount(String string) {
        return PdfUtilities.getPdfPageCount(new File(string));
    }

    public static int getPdfPageCount(File file) {
        if (PDFBOX.equals(System.getProperty(PDF_LIBRARY))) {
            return PdfBoxUtilities.getPdfPageCount(file);
        }
        try {
            return PdfGsUtilities.getPdfPageCount(file);
        }
        catch (Exception exception) {
            System.setProperty(PDF_LIBRARY, PDFBOX);
            return PdfUtilities.getPdfPageCount(file);
        }
    }

    public static void mergePdf(File[] fileArray, File file) {
        if (PDFBOX.equals(System.getProperty(PDF_LIBRARY))) {
            PdfBoxUtilities.mergePdf(fileArray, file);
        } else {
            try {
                PdfGsUtilities.mergePdf(fileArray, file);
            }
            catch (Exception exception) {
                System.setProperty(PDF_LIBRARY, PDFBOX);
                PdfUtilities.mergePdf(fileArray, file);
            }
        }
    }
}

