/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.util.Assert;
import org.apache.logging.log4j.core.util.Closer;

public class MemoryMappedFileManager
extends OutputStreamManager {
    static final int DEFAULT_REGION_LENGTH = 0x2000000;
    private static final MemoryMappedFileManagerFactory FACTORY = new MemoryMappedFileManagerFactory();
    private final boolean isForce;
    private final int regionLength;
    private final String advertiseURI;
    private final RandomAccessFile randomAccessFile;
    private final ThreadLocal<Boolean> isEndOfBatch = new ThreadLocal();
    private MappedByteBuffer mappedBuffer;
    private long mappingOffset;

    protected MemoryMappedFileManager(RandomAccessFile file, String fileName, OutputStream os, boolean force, long position, int regionLength, String advertiseURI, Layout<? extends Serializable> layout) throws IOException {
        super(os, fileName, layout);
        this.isForce = force;
        this.randomAccessFile = Assert.requireNonNull(file, "RandomAccessFile");
        this.regionLength = regionLength;
        this.advertiseURI = advertiseURI;
        this.isEndOfBatch.set(Boolean.FALSE);
        this.mappedBuffer = MemoryMappedFileManager.mmap(this.randomAccessFile.getChannel(), this.getFileName(), position, regionLength);
        this.mappingOffset = position;
    }

    public static MemoryMappedFileManager getFileManager(String fileName, boolean append, boolean isForce, int regionLength, String advertiseURI, Layout<? extends Serializable> layout) {
        return (MemoryMappedFileManager)MemoryMappedFileManager.getManager(fileName, new FactoryData(append, isForce, regionLength, advertiseURI, layout), FACTORY);
    }

    public Boolean isEndOfBatch() {
        return this.isEndOfBatch.get();
    }

    public void setEndOfBatch(boolean isEndOfBatch) {
        this.isEndOfBatch.set(isEndOfBatch);
    }

    @Override
    protected synchronized void write(byte[] bytes, int offset, int length) {
        super.write(bytes, offset, length);
        while (length > this.mappedBuffer.remaining()) {
            int chunk = this.mappedBuffer.remaining();
            this.mappedBuffer.put(bytes, offset, chunk);
            offset += chunk;
            length -= chunk;
            this.remap();
        }
        this.mappedBuffer.put(bytes, offset, length);
    }

    private synchronized void remap() {
        long offset = this.mappingOffset + (long)this.mappedBuffer.position();
        int length = this.mappedBuffer.remaining() + this.regionLength;
        try {
            MemoryMappedFileManager.unsafeUnmap(this.mappedBuffer);
            long fileLength = this.randomAccessFile.length() + (long)this.regionLength;
            LOGGER.debug("MMapAppender extending {} by {} bytes to {}", new Object[]{this.getFileName(), this.regionLength, fileLength});
            long startNanos = System.nanoTime();
            this.randomAccessFile.setLength(fileLength);
            float millis = (float)((double)(System.nanoTime() - startNanos) / 1000000.0);
            LOGGER.debug("MMapAppender extended {} OK in {} millis", new Object[]{this.getFileName(), Float.valueOf(millis)});
            this.mappedBuffer = MemoryMappedFileManager.mmap(this.randomAccessFile.getChannel(), this.getFileName(), offset, length);
            this.mappingOffset = offset;
        }
        catch (Exception ex) {
            LOGGER.error("Unable to remap " + this.getName() + ". " + ex);
        }
    }

    @Override
    public synchronized void flush() {
        this.mappedBuffer.force();
    }

    @Override
    public synchronized void close() {
        long position = this.mappedBuffer.position();
        long length = this.mappingOffset + position;
        try {
            MemoryMappedFileManager.unsafeUnmap(this.mappedBuffer);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to unmap MappedBuffer " + this.getName() + ". " + ex);
        }
        try {
            LOGGER.debug("MMapAppender closing. Setting {} length to {} (offset {} + position {})", new Object[]{this.getFileName(), length, this.mappingOffset, position});
            this.randomAccessFile.setLength(length);
            this.randomAccessFile.close();
        }
        catch (IOException ex) {
            LOGGER.error("Unable to close MemoryMappedFile " + this.getName() + ". " + ex);
        }
    }

    public static MappedByteBuffer mmap(FileChannel fileChannel, String fileName, long start, int size) throws IOException {
        int i = 1;
        while (true) {
            try {
                LOGGER.debug("MMapAppender remapping {} start={}, size={}", new Object[]{fileName, start, size});
                long startNanos = System.nanoTime();
                MappedByteBuffer map = fileChannel.map(FileChannel.MapMode.READ_WRITE, start, size);
                map.order(ByteOrder.nativeOrder());
                float millis = (float)((double)(System.nanoTime() - startNanos) / 1000000.0);
                LOGGER.debug("MMapAppender remapped {} OK in {} millis", new Object[]{fileName, Float.valueOf(millis)});
                return map;
            }
            catch (IOException e) {
                if (e.getMessage() == null || !e.getMessage().endsWith("user-mapped section open")) {
                    throw e;
                }
                LOGGER.debug("Remap attempt {}/10 failed. Retrying...", new Object[]{i, e});
                if (i < 10) {
                    Thread.yield();
                } else {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
                ++i;
                continue;
            }
            break;
        }
    }

    private static void unsafeUnmap(final MappedByteBuffer mbb) throws PrivilegedActionException {
        LOGGER.debug("MMapAppender unmapping old buffer...");
        long startNanos = System.nanoTime();
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                Method getCleanerMethod = mbb.getClass().getMethod("cleaner", new Class[0]);
                getCleanerMethod.setAccessible(true);
                Object cleaner = getCleanerMethod.invoke((Object)mbb, new Object[0]);
                Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                cleanMethod.invoke(cleaner, new Object[0]);
                return null;
            }
        });
        float millis = (float)((double)(System.nanoTime() - startNanos) / 1000000.0);
        LOGGER.debug("MMapAppender unmapped buffer OK in {} millis", new Object[]{Float.valueOf(millis)});
    }

    public String getFileName() {
        return this.getName();
    }

    public int getRegionLength() {
        return this.regionLength;
    }

    public boolean isImmediateFlush() {
        return this.isForce;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>(super.getContentFormat());
        result.put("fileURI", this.advertiseURI);
        return result;
    }

    private static class MemoryMappedFileManagerFactory
    implements ManagerFactory<MemoryMappedFileManager, FactoryData> {
        private MemoryMappedFileManagerFactory() {
        }

        @Override
        public MemoryMappedFileManager createManager(String name, FactoryData data) {
            File file = new File(name);
            File parent = file.getParentFile();
            if (null != parent && !parent.exists()) {
                parent.mkdirs();
            }
            if (!data.append) {
                file.delete();
            }
            DummyOutputStream os = new DummyOutputStream();
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(name, "rw");
                long position = data.append ? raf.length() : 0L;
                raf.setLength(position + (long)data.regionLength);
                return new MemoryMappedFileManager(raf, name, os, data.force, position, data.regionLength, data.advertiseURI, data.layout);
            }
            catch (Exception ex) {
                AbstractManager.LOGGER.error("MemoryMappedFileManager (" + name + ") " + ex);
                Closer.closeSilently(raf);
                return null;
            }
        }
    }

    private static class FactoryData {
        private final boolean append;
        private final boolean force;
        private final int regionLength;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;

        public FactoryData(boolean append, boolean force, int regionLength, String advertiseURI, Layout<? extends Serializable> layout) {
            this.append = append;
            this.force = force;
            this.regionLength = regionLength;
            this.advertiseURI = advertiseURI;
            this.layout = layout;
        }
    }

    static class DummyOutputStream
    extends OutputStream {
        DummyOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

