/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.archetype.old.ArchetypeTemplateProcessingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PomUtils {
    private PomUtils() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static boolean addNewModule(String artifactId, Reader fileReader, Writer fileWriter) throws ArchetypeTemplateProcessingException, InvalidPackaging, IOException, ParserConfigurationException, SAXException, TransformerException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(fileReader);
        Document document = db.parse(inputSource);
        Element project = document.getDocumentElement();
        if (!"project".equals(project.getNodeName())) {
            throw new ArchetypeTemplateProcessingException("Unable to find root element 'project'.");
        }
        String packaging = null;
        Node packagingNode = PomUtils.getChildNode(project, "packaging");
        if (packagingNode != null) {
            packaging = packagingNode.getTextContent();
        }
        if (!"pom".equals(packaging)) {
            throw new InvalidPackaging("Unable to add module to the current project as it is not of packaging type 'pom'");
        }
        Node modules = PomUtils.getChildNode(project, "modules");
        if (!PomUtils.hasArtifactIdInModules(artifactId, modules)) {
            Element module = document.createElement("module");
            module.setTextContent(artifactId);
            if (modules == null) {
                modules = document.createElement("modules");
                project.appendChild(modules);
            }
            modules.appendChild(document.createTextNode("  "));
            modules.appendChild(module);
            modules.appendChild(document.createTextNode("\n  "));
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            tf.setAttribute("indent-number", 2);
            try (InputStream xsl = PomUtils.class.getResourceAsStream("/prettyprint.xsl");){
                Transformer tr = tf.newTransformer(new StreamSource(xsl));
                tr.setOutputProperty("indent", "yes");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", "UTF-8");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                document.getDomConfig().setParameter("infoset", Boolean.TRUE);
                document.getDocumentElement().normalize();
                tr.transform(new DOMSource(document), new StreamResult(fileWriter));
            }
            return true;
        }
        return false;
    }

    private static Node getChildNode(Element parent, String name) {
        Node namedNode = null;
        NodeList nodes = parent.getChildNodes();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !name.equals(node.getNodeName())) continue;
            namedNode = node;
            break;
        }
        return namedNode;
    }

    private static boolean hasArtifactIdInModules(String artifactId, Node modules) {
        if (modules != null) {
            for (Node module = modules.getFirstChild(); module != null; module = module.getNextSibling()) {
                if (module.getNodeType() != 1 || !artifactId.equals(module.getTextContent())) continue;
                return true;
            }
        }
        return false;
    }
}

