/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.downloader;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.Downloader;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Named
@Singleton
public class DefaultDownloader
implements Downloader {
    @Inject
    private RepositorySystem repositorySystem;

    @Override
    public File download(String groupId, String artifactId, String version, List<RemoteRepository> remoteRepositories, RepositorySystemSession repositorySystemSession) throws DownloadException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "", "jar", version);
        ArtifactRequest request = new ArtifactRequest((Artifact)artifact, remoteRepositories, "archetype");
        try {
            ArtifactResult result = this.repositorySystem.resolveArtifact(repositorySystemSession, request);
            return result.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new DownloadException("Could not resolve artifact " + artifactId, e);
        }
    }
}

