/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.model.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.archetype.model.ArchetypeModel;
import org.apache.maven.archetype.model.Resource;
import org.apache.maven.archetype.model.Source;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ArchetypeXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, ArchetypeModel archetypeModel) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(archetypeModel.getModelEncoding(), null);
        this.writeArchetypeModel(archetypeModel, "archetype", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, ArchetypeModel archetypeModel) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, archetypeModel.getModelEncoding());
        serializer.startDocument(archetypeModel.getModelEncoding(), null);
        this.writeArchetypeModel(archetypeModel, "archetype", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeArchetypeModel(ArchetypeModel archetypeModel, String tagName, XmlSerializer serializer) throws IOException {
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("", "http://maven.apache.org/plugins/maven-archetype-plugin/archetype/1.0.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/plugins/maven-archetype-plugin/archetype/1.0.0 https://maven.apache.org/xsd/archetype-1.0.0.xsd");
        if (archetypeModel.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(archetypeModel.getId()).endTag(NAMESPACE, "id");
        }
        if (archetypeModel.isAllowPartial()) {
            serializer.startTag(NAMESPACE, "allowPartial").text(String.valueOf(archetypeModel.isAllowPartial())).endTag(NAMESPACE, "allowPartial");
        }
        if (archetypeModel.getSources() != null && archetypeModel.getSources().size() > 0) {
            serializer.startTag(NAMESPACE, "sources");
            for (Source source : archetypeModel.getSources()) {
                this.writeSource(source, "source", serializer);
            }
            serializer.endTag(NAMESPACE, "sources");
        }
        if (archetypeModel.getResources() != null && archetypeModel.getResources().size() > 0) {
            serializer.startTag(NAMESPACE, "resources");
            for (Resource resource : archetypeModel.getResources()) {
                this.writeResource(resource, "resource", serializer);
            }
            serializer.endTag(NAMESPACE, "resources");
        }
        if (archetypeModel.getTestSources() != null && archetypeModel.getTestSources().size() > 0) {
            serializer.startTag(NAMESPACE, "testSources");
            for (Source source : archetypeModel.getTestSources()) {
                this.writeSource(source, "source", serializer);
            }
            serializer.endTag(NAMESPACE, "testSources");
        }
        if (archetypeModel.getTestResources() != null && archetypeModel.getTestResources().size() > 0) {
            serializer.startTag(NAMESPACE, "testResources");
            for (Resource resource : archetypeModel.getTestResources()) {
                this.writeResource(resource, "resource", serializer);
            }
            serializer.endTag(NAMESPACE, "testResources");
        }
        if (archetypeModel.getSiteResources() != null && archetypeModel.getSiteResources().size() > 0) {
            serializer.startTag(NAMESPACE, "siteResources");
            for (Resource resource : archetypeModel.getSiteResources()) {
                this.writeResource(resource, "resource", serializer);
            }
            serializer.endTag(NAMESPACE, "siteResources");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeResource(Resource resource, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (resource.getEncoding() != null) {
            serializer.attribute(NAMESPACE, "encoding", resource.getEncoding());
        }
        if (!resource.isFiltered()) {
            serializer.attribute(NAMESPACE, "filtered", String.valueOf(resource.isFiltered()));
        }
        serializer.text(resource.getFile());
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeSource(Source source, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (source.getEncoding() != null) {
            serializer.attribute(NAMESPACE, "encoding", source.getEncoding());
        }
        serializer.text(source.getFile());
        serializer.endTag(NAMESPACE, tagName);
    }
}

