/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.archetype.ArchetypeCreationRequest;
import org.apache.maven.archetype.ArchetypeCreationResult;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.common.Constants;
import org.apache.maven.archetype.ui.creation.ArchetypeCreationConfigurator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="create-from-project", requiresProject=true, aggregator=true)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class CreateArchetypeFromProjectMojo
extends AbstractMojo {
    @Parameter(property="interactive", defaultValue="false")
    private boolean interactive;
    @Parameter(property="archetype.filteredExtentions")
    private String archetypeFilteredExtentions;
    @Parameter(property="archetype.languages")
    private String archetypeLanguages;
    @Parameter(property="archetype.encoding", defaultValue="UTF-8")
    private String defaultEncoding;
    @Parameter(property="archetype.partialArchetype")
    private boolean partialArchetype = false;
    @Parameter(property="archetype.preserveCData")
    private boolean preserveCData = false;
    @Parameter(property="archetype.keepParent")
    private boolean keepParent = true;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="archetype.properties", property="archetype.properties")
    private File propertyFile;
    @Parameter(property="archetype.postPhase", defaultValue="package")
    private String archetypePostPhase;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/archetype", property="outputDirectory")
    private File outputDirectory;
    @Parameter(property="testMode")
    private boolean testMode;
    @Parameter(property="packageName")
    private String packageName;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    private ArchetypeCreationConfigurator configurator;
    private ArchetypeManager manager;

    @Inject
    public CreateArchetypeFromProjectMojo(ArchetypeCreationConfigurator configurator, ArchetypeManager manager) {
        this.configurator = configurator;
        this.manager = manager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        Properties executionProperties = new Properties(this.session.getSystemProperties());
        executionProperties.putAll((Map<?, ?>)this.session.getUserProperties());
        try {
            if (this.propertyFile != null) {
                this.propertyFile.getParentFile().mkdirs();
            }
            List<String> languages = this.getLanguages(this.archetypeLanguages, this.propertyFile);
            Properties properties = this.configurator.configureArchetypeCreation(this.project, this.interactive, executionProperties, this.propertyFile, languages);
            List<String> filtereds = this.getFilteredExtensions(this.archetypeFilteredExtentions, this.propertyFile);
            ArchetypeCreationRequest request = new ArchetypeCreationRequest().setDefaultEncoding(this.defaultEncoding).setProject(this.project).setProperties(properties).setLanguages(languages).setFiltereds(filtereds).setPreserveCData(this.preserveCData).setKeepParent(this.keepParent).setPartialArchetype(this.partialArchetype).setLocalRepositoryBasedir(this.session.getRepositorySession().getLocalRepository().getBasedir()).setPackageName(this.packageName).setPostPhase(this.archetypePostPhase).setOutputDirectory(this.outputDirectory).setSettingsFile(this.session.getRequest().getUserSettingsFile());
            ArchetypeCreationResult result = this.manager.createArchetypeFromProject(request);
            if (result.getCause() != null) {
                throw new MojoExecutionException(result.getCause().getMessage(), result.getCause());
            }
            this.getLog().info((CharSequence)("Archetype project created in " + this.outputDirectory));
            if (!this.testMode) return;
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private List<String> getFilteredExtensions(String archetypeFilteredExtentions, File propertyFile) throws IOException {
        ArrayList<String> filteredExtensions = new ArrayList<String>();
        if (archetypeFilteredExtentions != null && !archetypeFilteredExtentions.isEmpty()) {
            filteredExtensions.addAll(Arrays.asList(StringUtils.split((String)archetypeFilteredExtentions, (String)",")));
            this.getLog().debug((CharSequence)("Found in command line extensions = " + filteredExtensions));
        }
        if (filteredExtensions.isEmpty() && propertyFile != null && propertyFile.exists()) {
            Properties properties = PropertyUtils.loadProperties((File)propertyFile);
            String extensions = properties.getProperty("archetype.filteredExtensions");
            if (extensions != null && !extensions.isEmpty()) {
                filteredExtensions.addAll(Arrays.asList(StringUtils.split((String)extensions, (String)",")));
            }
            this.getLog().debug((CharSequence)("Found in propertyFile " + propertyFile.getName() + " extensions = " + filteredExtensions));
        }
        if (filteredExtensions.isEmpty()) {
            filteredExtensions.addAll(Constants.DEFAULT_FILTERED_EXTENSIONS);
            this.getLog().debug((CharSequence)("Using default extensions = " + filteredExtensions));
        }
        return filteredExtensions;
    }

    private List<String> getLanguages(String archetypeLanguages, File propertyFile) throws IOException {
        ArrayList<String> resultingLanguages = new ArrayList<String>();
        if (archetypeLanguages != null && !archetypeLanguages.isEmpty()) {
            resultingLanguages.addAll(Arrays.asList(StringUtils.split((String)archetypeLanguages, (String)",")));
            this.getLog().debug((CharSequence)("Found in command line languages = " + resultingLanguages));
        }
        if (resultingLanguages.isEmpty() && propertyFile != null && propertyFile.exists()) {
            Properties properties = PropertyUtils.loadProperties((File)propertyFile);
            String languages = properties.getProperty("archetype.languages");
            if (languages != null && !languages.isEmpty()) {
                resultingLanguages.addAll(Arrays.asList(StringUtils.split((String)languages, (String)",")));
            }
            this.getLog().debug((CharSequence)("Found in propertyFile " + propertyFile.getName() + " languages = " + resultingLanguages));
        }
        if (resultingLanguages.isEmpty()) {
            resultingLanguages.addAll(Constants.DEFAULT_LANGUAGES);
            this.getLog().debug((CharSequence)("Using default languages = " + resultingLanguages));
        }
        return resultingLanguages;
    }
}

