/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationConfigurator;
import org.apache.maven.archetype.ui.generation.ArchetypeSelector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="generate", requiresProject=false)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class CreateProjectFromArchetypeMojo
extends AbstractMojo
implements ContextEnabled {
    private ArchetypeManager manager;
    private ArchetypeSelector selector;
    private ArchetypeGenerationConfigurator configurator;
    private Invoker invoker;
    private RepositorySystem repositorySystem;
    @Parameter(property="archetypeArtifactId")
    private String archetypeArtifactId;
    @Parameter(property="archetypeGroupId")
    private String archetypeGroupId;
    @Parameter(property="archetypeVersion")
    private String archetypeVersion;
    @Parameter(property="archetypeCatalog", defaultValue="remote,local")
    private String archetypeCatalog;
    @Parameter(property="askForDefaultPropertyValues", defaultValue="false", required=true)
    private Boolean askForDefaultPropertyValues;
    @Parameter(property="interactiveMode", defaultValue="${settings.interactiveMode}", required=true)
    private Boolean interactiveMode;
    @Parameter(defaultValue="${basedir}", property="outputDirectory")
    private File outputDirectory;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="goals")
    private String goals;
    @Parameter(property="filter")
    private String filter;

    @Inject
    public CreateProjectFromArchetypeMojo(ArchetypeManager manager, ArchetypeSelector selector, ArchetypeGenerationConfigurator configurator, Invoker invoker, RepositorySystem repositorySystem) {
        this.manager = manager;
        this.selector = selector;
        this.configurator = configurator;
        this.invoker = invoker;
        this.repositorySystem = repositorySystem;
    }

    public void execute() throws MojoExecutionException {
        Properties executionProperties = this.session.getUserProperties();
        ArchetypeGenerationRequest request = new ArchetypeGenerationRequest().setArchetypeGroupId(this.archetypeGroupId).setArchetypeArtifactId(this.archetypeArtifactId).setArchetypeVersion(this.archetypeVersion).setOutputDirectory(this.outputDirectory.getAbsolutePath()).setRemoteRepositories(this.project.getRemoteProjectRepositories()).setRemoteArtifactRepositories(this.project.getRemoteArtifactRepositories()).setMavenSession(this.session).setRepositorySession(this.session.getRepositorySession()).setRepositorySystem(this.repositorySystem).setProjectBuildingRequest(this.session.getProjectBuildingRequest()).setLocalRepository(this.session.getLocalRepository()).setOffline(this.session.isOffline()).setFilter(this.filter).setAskForDefaultPropertyValues(this.askForDefaultPropertyValues.booleanValue());
        try {
            if (this.interactiveMode.booleanValue()) {
                this.getLog().info((CharSequence)"Generating project in Interactive mode");
            } else {
                this.getLog().info((CharSequence)"Generating project in Batch mode");
            }
            this.selector.selectArchetype(request, this.interactiveMode, this.archetypeCatalog);
            if (StringUtils.isBlank((CharSequence)request.getArchetypeArtifactId())) {
                return;
            }
            this.configurator.configureArchetype(request, this.interactiveMode, executionProperties);
            ArchetypeGenerationResult generationResult = this.manager.generateProjectFromArchetype(request);
            if (generationResult.getCause() != null) {
                throw new MojoExecutionException(generationResult.getCause().getMessage(), generationResult.getCause());
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        String artifactId = request.getArtifactId();
        String postArchetypeGenerationGoals = request.getArchetypeGoals();
        if (postArchetypeGenerationGoals == null || postArchetypeGenerationGoals.isEmpty()) {
            postArchetypeGenerationGoals = this.goals;
        }
        if (postArchetypeGenerationGoals != null && !postArchetypeGenerationGoals.isEmpty()) {
            this.invokePostArchetypeGenerationGoals(postArchetypeGenerationGoals, artifactId);
        }
    }

    private void invokePostArchetypeGenerationGoals(String goals, String artifactId) throws MojoExecutionException {
        block4: {
            this.getLog().info((CharSequence)("Invoking post-archetype-generation goals: " + goals));
            File projectBasedir = new File(this.outputDirectory, artifactId);
            if (projectBasedir.exists()) {
                InvocationRequest request = new DefaultInvocationRequest().setBaseDirectory(projectBasedir).setGoals(Arrays.asList(StringUtils.split((String)goals, (String)",")));
                try {
                    InvocationResult result = this.invoker.execute(request);
                    if (result.getExitCode() != 0) {
                        throw new MojoExecutionException("Failed to invoke goals", (Exception)result.getExecutionException());
                    }
                    break block4;
                }
                catch (MavenInvocationException e) {
                    throw new MojoExecutionException("Cannot run additions goals.", (Exception)((Object)e));
                }
            }
            this.getLog().info((CharSequence)("Post-archetype-generation goals aborted: unavailable basedir " + projectBasedir));
        }
    }
}

