/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.CodeList;

public class CodeListSet<E extends CodeList<E>>
extends AbstractSet<E>
implements CheckedContainer<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6328082298556260980L;
    private static final WeakHashSet<CodeList[]> POOL = new WeakHashSet<CodeList[]>(CodeList[].class);
    private final Class<E> elementType;
    private long values;
    private BitSet supplementary;
    private transient E[] codes;

    public CodeListSet(Class<E> clazz) throws IllegalArgumentException {
        if (!Modifier.isFinal(clazz.getModifiers())) {
            throw new IllegalArgumentException(Errors.format((short)19, clazz));
        }
        this.elementType = clazz;
    }

    public CodeListSet(Class<E> clazz, boolean bl) throws IllegalArgumentException {
        this(clazz);
        if (bl) {
            this.codes = POOL.unique(Types.getCodeValues(clazz));
            int n = this.codes.length;
            if (n < 64) {
                this.values = (1L << n) - 1L;
            } else {
                this.values = -1L;
                if ((n -= 64) != 0) {
                    this.supplementary = new BitSet(n);
                    this.supplementary.set(0, n);
                }
            }
        }
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    final E valueOf(int n) {
        Object[] objectArray = this.codes;
        if (objectArray == null || n >= objectArray.length) {
            this.codes = objectArray = POOL.unique(Types.getCodeValues(this.elementType));
        }
        return objectArray[n];
    }

    @Override
    public void clear() {
        this.values = 0L;
        BitSet bitSet = this.supplementary;
        if (bitSet != null) {
            bitSet.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        BitSet bitSet;
        return this.values == 0L && ((bitSet = this.supplementary) == null || bitSet.isEmpty());
    }

    @Override
    public int size() {
        int n = Long.bitCount(this.values);
        BitSet bitSet = this.supplementary;
        if (bitSet != null) {
            n += bitSet.cardinality();
        }
        return n;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            String string = CheckedArrayList.illegalElement(this, e, this.elementType);
            if (string == null) {
                return false;
            }
            throw new NullArgumentException(string);
        }
        int n = e.ordinal();
        if (n < 64) {
            return (this.values |= 1L << n) != this.values;
        }
        BitSet bitSet = this.supplementary;
        if (bitSet == null) {
            this.supplementary = bitSet = new BitSet();
        }
        if (bitSet.get(n -= 64)) {
            return false;
        }
        bitSet.set(n);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        if (this.elementType.isInstance(object)) {
            return this.clear(((CodeList)object).ordinal());
        }
        return false;
    }

    final boolean clear(int n) {
        if (n < 64) {
            return (this.values &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) != this.values;
        }
        BitSet bitSet = this.supplementary;
        if (bitSet != null && bitSet.get(n -= 64)) {
            bitSet.clear(n);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        if (this.elementType.isInstance(object)) {
            int n = ((CodeList)object).ordinal();
            if (n < 64) {
                return (this.values & 1L << n) != 0L;
            }
            BitSet bitSet = this.supplementary;
            if (bitSet != null) {
                return bitSet.get(n - 64);
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof CodeListSet) {
            CodeListSet codeListSet = (CodeListSet)collection;
            if (this.elementType == codeListSet.elementType && this.values == (this.values | codeListSet.values)) {
                BitSet bitSet = this.supplementary;
                BitSet bitSet2 = codeListSet.supplementary;
                if ((bitSet == null || bitSet.isEmpty()) && (bitSet2 == null || bitSet2.isEmpty())) {
                    return true;
                }
                if (bitSet != null && bitSet2 != null) {
                    BitSet bitSet3 = (BitSet)bitSet2.clone();
                    bitSet3.andNot(bitSet);
                    return bitSet3.isEmpty();
                }
            }
            return false;
        }
        return super.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException {
        if (collection instanceof CodeListSet) {
            CodeListSet codeListSet = (CodeListSet)collection;
            assert (this.elementType.isAssignableFrom(codeListSet.elementType));
            boolean bl = (this.values |= codeListSet.values) != this.values;
            BitSet bitSet = codeListSet.supplementary;
            if (bitSet != null) {
                BitSet bitSet2 = this.supplementary;
                if (bitSet2 == null) {
                    if (!bitSet.isEmpty()) {
                        this.supplementary = (BitSet)bitSet.clone();
                        bl = true;
                    }
                } else if (bl) {
                    bitSet2.or(bitSet);
                } else {
                    int n = bitSet2.cardinality();
                    bitSet2.or(bitSet);
                    bl = n != bitSet2.cardinality();
                }
            }
            return bl;
        }
        return super.addAll(collection);
    }

    private long mask(CodeListSet<?> codeListSet) {
        return this.elementType == codeListSet.elementType ? codeListSet.values : 0L;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection instanceof CodeListSet) {
            BitSet bitSet;
            boolean bl = (this.values &= this.mask((CodeListSet)collection) ^ 0xFFFFFFFFFFFFFFFFL) != this.values;
            BitSet bitSet2 = this.supplementary;
            if (bitSet2 != null && (bitSet = ((CodeListSet)collection).supplementary) != null) {
                if (bl) {
                    bitSet2.andNot(bitSet);
                } else {
                    int n = bitSet2.cardinality();
                    bitSet2.andNot(bitSet);
                    bl = n != bitSet2.cardinality();
                }
            }
            return bl;
        }
        return super.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection instanceof CodeListSet) {
            boolean bl = (this.values &= this.mask((CodeListSet)collection)) != this.values;
            BitSet bitSet = this.supplementary;
            if (bitSet != null) {
                BitSet bitSet2 = ((CodeListSet)collection).supplementary;
                if (bitSet2 == null) {
                    bl |= !bitSet.isEmpty();
                    bitSet.clear();
                } else if (bl) {
                    bitSet.and(bitSet2);
                } else {
                    int n = bitSet.cardinality();
                    bitSet.and(bitSet2);
                    bl = n != bitSet.cardinality();
                }
            }
            return bl;
        }
        return super.retainAll(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(this.values, this.supplementary);
    }

    public CodeListSet<E> clone() {
        CodeListSet codeListSet;
        try {
            codeListSet = (CodeListSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        BitSet bitSet = this.supplementary;
        if (bitSet != null) {
            codeListSet.supplementary = (BitSet)bitSet.clone();
        }
        return codeListSet;
    }

    private final class Iter
    implements Iterator<E> {
        private long remaining;
        private final BitSet more;
        private int last;

        Iter(long l, BitSet bitSet) {
            this.remaining = l;
            this.more = bitSet != null ? (BitSet)bitSet.clone() : null;
            this.last = -1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining != 0L || this.more != null && !this.more.isEmpty();
        }

        @Override
        public E next() {
            int n = Long.numberOfTrailingZeros(this.remaining);
            if (n >= 64) {
                if (this.more == null || (n = this.more.nextSetBit(0)) < 0) {
                    throw new NoSuchElementException();
                }
                this.more.clear(n);
                n += 64;
            }
            this.last = n;
            this.remaining &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
            return CodeListSet.this.valueOf(n);
        }

        @Override
        public void remove() {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            CodeListSet.this.clear(this.last);
            this.last = -1;
        }
    }
}

