/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONWriter;

public class ClusterState
implements JSONWriter.Writable {
    private final Integer znodeVersion;
    private final Map<String, CollectionRef> collectionStates;
    private final Map<String, CollectionRef> immutableCollectionStates;
    private Set<String> liveNodes;

    public ClusterState(Integer znodeVersion, Set<String> liveNodes, Map<String, DocCollection> collectionStates) {
        this(liveNodes, ClusterState.getRefMap(collectionStates), znodeVersion);
    }

    private static Map<String, CollectionRef> getRefMap(Map<String, DocCollection> collectionStates) {
        LinkedHashMap<String, CollectionRef> collRefs = new LinkedHashMap<String, CollectionRef>(collectionStates.size());
        for (Map.Entry<String, DocCollection> entry : collectionStates.entrySet()) {
            DocCollection c = entry.getValue();
            collRefs.put(entry.getKey(), new CollectionRef(c));
        }
        return collRefs;
    }

    public ClusterState(Set<String> liveNodes, Map<String, CollectionRef> collectionStates, Integer znodeVersion) {
        this.znodeVersion = znodeVersion;
        this.liveNodes = new HashSet<String>(liveNodes.size());
        this.liveNodes.addAll(liveNodes);
        this.collectionStates = new LinkedHashMap<String, CollectionRef>(collectionStates);
        this.immutableCollectionStates = Collections.unmodifiableMap(collectionStates);
    }

    public ClusterState copyWith(String collectionName, DocCollection collection) {
        ClusterState result = new ClusterState(this.liveNodes, new LinkedHashMap<String, CollectionRef>(this.collectionStates), this.znodeVersion);
        if (collection == null) {
            result.collectionStates.remove(collectionName);
        } else {
            result.collectionStates.put(collectionName, new CollectionRef(collection));
        }
        return result;
    }

    @Deprecated
    public Replica getLeader(String collection, String sliceName) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        Slice slice = coll.getSlice(sliceName);
        if (slice == null) {
            return null;
        }
        return slice.getLeader();
    }

    public boolean hasCollection(String collectionName) {
        return this.getCollectionOrNull(collectionName) != null;
    }

    @Deprecated
    public Replica getReplica(String collection, String coreNodeName) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        for (Slice slice : coll.getSlices()) {
            Replica replica = slice.getReplica(coreNodeName);
            if (replica == null) continue;
            return replica;
        }
        return null;
    }

    @Deprecated
    public Slice getSlice(String collection, String sliceName) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getSlice(sliceName);
    }

    @Deprecated
    public Map<String, Slice> getSlicesMap(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getSlicesMap();
    }

    @Deprecated
    public Map<String, Slice> getActiveSlicesMap(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getActiveSlicesMap();
    }

    @Deprecated
    public Collection<Slice> getSlices(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getSlices();
    }

    @Deprecated
    public Collection<Slice> getActiveSlices(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getActiveSlices();
    }

    public DocCollection getCollection(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection : " + collection);
        }
        return coll;
    }

    public CollectionRef getCollectionRef(String coll) {
        return this.collectionStates.get(coll);
    }

    public DocCollection getCollectionOrNull(String collectionName) {
        CollectionRef ref = this.collectionStates.get(collectionName);
        return ref == null ? null : ref.get();
    }

    @Deprecated
    public Set<String> getCollections() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, CollectionRef> entry : this.collectionStates.entrySet()) {
            if (entry.getValue().get() == null) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Map<String, DocCollection> getCollectionsMap() {
        HashMap<String, DocCollection> result = new HashMap<String, DocCollection>(this.collectionStates.size());
        for (Map.Entry<String, CollectionRef> entry : this.collectionStates.entrySet()) {
            DocCollection collection = entry.getValue().get();
            if (collection == null) continue;
            result.put(entry.getKey(), collection);
        }
        return result;
    }

    public Set<String> getLiveNodes() {
        return Collections.unmodifiableSet(this.liveNodes);
    }

    public String getShardId(String nodeName, String coreName) {
        return this.getShardId(null, nodeName, coreName);
    }

    public String getShardId(String collectionName, String nodeName, String coreName) {
        CollectionRef c;
        Collection<CollectionRef> states = this.collectionStates.values();
        if (collectionName != null && (c = this.collectionStates.get(collectionName)) != null) {
            states = Collections.singletonList(c);
        }
        for (CollectionRef ref : states) {
            DocCollection coll = ref.get();
            if (coll == null) continue;
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    String rnodeName = replica.getStr("node_name");
                    String rcore = replica.getStr("core");
                    if (!nodeName.equals(rnodeName) || !coreName.equals(rcore)) continue;
                    return slice.getName();
                }
            }
        }
        return null;
    }

    public boolean liveNodesContain(String name) {
        return this.liveNodes.contains(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("live nodes:" + this.liveNodes);
        sb.append("collections:" + this.collectionStates);
        return sb.toString();
    }

    public static ClusterState load(Integer version, byte[] bytes, Set<String> liveNodes) {
        return ClusterState.load(version, bytes, liveNodes, "/clusterstate.json");
    }

    public static ClusterState load(Integer version, byte[] bytes, Set<String> liveNodes, String znode) {
        if (bytes == null || bytes.length == 0) {
            return new ClusterState(version, liveNodes, Collections.emptyMap());
        }
        Map stateMap = (Map)Utils.fromJSON(bytes);
        LinkedHashMap<String, CollectionRef> collections = new LinkedHashMap<String, CollectionRef>(stateMap.size());
        for (Map.Entry entry : stateMap.entrySet()) {
            String collectionName = (String)entry.getKey();
            DocCollection coll = ClusterState.collectionFromObjects(collectionName, (Map)entry.getValue(), version, znode);
            collections.put(collectionName, new CollectionRef(coll));
        }
        return new ClusterState(liveNodes, collections, version);
    }

    public static Aliases load(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new Aliases();
        }
        Map aliasMap = (Map)Utils.fromJSON(bytes);
        return new Aliases(aliasMap);
    }

    private static DocCollection collectionFromObjects(String name, Map<String, Object> objs, Integer version, String znode) {
        DocRouter router;
        Map<String, Object> props;
        Map<String, Slice> slices;
        Map sliceObjs = (Map)objs.get("shards");
        if (sliceObjs == null) {
            slices = Slice.loadAllFromMap(objs);
            props = Collections.emptyMap();
        } else {
            slices = Slice.loadAllFromMap(sliceObjs);
            props = new HashMap<String, Object>(objs);
            objs.remove("shards");
        }
        Object routerObj = props.get("router");
        if (routerObj == null) {
            router = DocRouter.DEFAULT;
        } else if (routerObj instanceof String) {
            router = DocRouter.getDocRouter((String)routerObj);
        } else {
            Map routerProps = (Map)routerObj;
            router = DocRouter.getDocRouter((String)routerProps.get("name"));
        }
        return new DocCollection(name, slices, props, router, version, znode);
    }

    public void write(JSONWriter jsonWriter) {
        LinkedHashMap<String, DocCollection> map = new LinkedHashMap<String, DocCollection>();
        for (Map.Entry<String, CollectionRef> e : this.collectionStates.entrySet()) {
            DocCollection coll;
            if (e.getValue().getClass() != CollectionRef.class || (coll = e.getValue().get()).getStateFormat() != 1) continue;
            map.put(coll.getName(), coll);
        }
        jsonWriter.write(map);
    }

    @Deprecated
    public Integer getZkClusterStateVersion() {
        return this.znodeVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.znodeVersion == null ? 0 : this.znodeVersion.hashCode());
        result = 31 * result + (this.liveNodes == null ? 0 : this.liveNodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterState other = (ClusterState)obj;
        if (this.znodeVersion == null ? other.znodeVersion != null : !this.znodeVersion.equals(other.znodeVersion)) {
            return false;
        }
        return !(this.liveNodes == null ? other.liveNodes != null : !this.liveNodes.equals(other.liveNodes));
    }

    void setLiveNodes(Set<String> liveNodes) {
        this.liveNodes = liveNodes;
    }

    public Map<String, CollectionRef> getCollectionStates() {
        return this.immutableCollectionStates;
    }

    public static class CollectionRef {
        private final DocCollection coll;

        public CollectionRef(DocCollection coll) {
            this.coll = coll;
        }

        public DocCollection get() {
            return this.coll;
        }

        public boolean isLazilyLoaded() {
            return false;
        }

        public String toString() {
            if (this.coll != null) {
                return this.coll.toString();
            }
            return "null DocCollection ref";
        }
    }
}

